/* KinokoEventProcessor.cc */
/* Created by Enomoto Sanshiro on 4 September 2009. */
/* Last updated by Enomoto Sanshiro on 4 September 2009. */


#include <string>
#include <iostream>
#include "KinokoDataProcessor.hh"
#include "KinokoEventEnvelope.hh"
#include "KinokoEventProcessor.hh"

using namespace std;


TKinokoEventProcessor::TKinokoEventProcessor(const std::string& InputDataSourceName, TKinokoEventSegmentProcessor* SegmentProcessor)
{
    _EnvelopeReader = new TKinokoEventEnvelopeReader(SegmentProcessor);

    if (! InputDataSourceName.empty()) {
	_EnvelopeReader->AddTargetDataSource(InputDataSourceName);
    }
}

TKinokoEventProcessor::~TKinokoEventProcessor()
{
    delete _EnvelopeReader;
}

void TKinokoEventProcessor::OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    _EnvelopeReader->ProcessPacket(Packet, PacketSize);
}



TKinokoEventConsumer::TKinokoEventConsumer(const std::string& InputDataSourceName, TKinokoEventSegmentProcessor* SegmentProcessor)
{
    _EnvelopeReader = new TKinokoEventEnvelopeReader(SegmentProcessor);

    if (! InputDataSourceName.empty()) {
	_EnvelopeReader->AddTargetDataSource(InputDataSourceName);
    }
}

TKinokoEventConsumer::~TKinokoEventConsumer()
{
    delete _EnvelopeReader;
}

void TKinokoEventConsumer::OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    _EnvelopeReader->ProcessPacket(Packet, PacketSize);
}
