/* KinokoEventProcessor.hh */
/* Created by Enomoto Sanshiro on 4 September 2009. */
/* Last updated by Enomoto Sanshiro on 4 September 2009. */


#ifndef __KinokoEventProcessor_hh__
#define __KinokoEventProcessor_hh__


#include <string>
#include <iostream>
#include "KinokoDataProcessor.hh"
#include "KinokoEventEnvelope.hh"


class TKinokoEventProcessor: public TKinokoDataProcessor {
  public:
    TKinokoEventProcessor(const std::string& InputDataSourceName, TKinokoEventSegmentProcessor* SegmentProcessor);
    virtual ~TKinokoEventProcessor();
    virtual void BuildDataSource(TKinokoDataSource* DataSource) = 0;
  protected:
    virtual void OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventEnvelopeReader* _EnvelopeReader;
};


class TKinokoEventConsumer: public TKinokoDataConsumer {
  public:
    TKinokoEventConsumer(const std::string& InputDataSourceName, TKinokoEventSegmentProcessor* SegmentProcessor);
    virtual ~TKinokoEventConsumer();
  protected:
    virtual void OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventEnvelopeReader* _EnvelopeReader;
};


#endif
