/* KinokoSorterController.hh */
/* Created by Enomoto Sanshiro on 8 May 2010. */
/* Last updated by Enomoto Sanshiro on 18 May 2010. */


#ifndef __KinokoSorterController_hh__
#define __KinokoSorterController_hh__

#include <iostream>
#include "KinokoEventPiece.hh"
#include "KinokoEventSorter.hh"


class TKinokoSorterController: public TKinokoEventPieceDefs {
  public:
    TKinokoSorterController(TKinokoEventSorter& Sorter, const TKinokoArena& Arena);
    virtual ~TKinokoSorterController();
    virtual void SetStartDataSize(size_t StartDataSize);
    virtual void RegisterStream(TStreamKey StreamKey);
    virtual void SetStartPacketCycles(int NumberOfPacketCycles);
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void DoTransaction(void);
  protected:
    virtual void TestReadinessToStart(void);
    virtual void TestReadinessToStartByChannelTable(void);
    virtual void TestReadinessToStartByPacketCycles(void);
  protected:
    TKinokoEventSorter& _Sorter;
    const TKinokoArena& _Arena;
    bool _IsReadyToStart;
    size_t _StartDataSize;
    int _StartPacketCycles;
    std::vector<int> _RegisteredChannelIndexList;
  private:
    std::vector<long> _ChannelPieceCountList;
    std::vector<long> _ChannelPacketCountList;
};


#endif
