/* KinokoSorterProcessor.cc */
/* Created by Enomoto Sanshiro on 23 April 2010. */
/* Last updated by Enomoto Sanshiro on 5 May 2010. */


#include <iostream>
#include "KinokoEventSorter.hh"
#include "KinokoEventSegmentPacker.hh"
#include "KinokoBuilderProcessor.hh"
#include "KinokoSorterProcessor.hh"

using namespace std;


TKinokoEventPieceSorter::TKinokoEventPieceSorter(TKinokoEventSegmentProcessor* OutputSegmentProcessor, void* Buffer, TKinokoArena& Arena) 
: _Sorter(
    _Packer = new TKinokoEventSegmentPacker(OutputSegmentProcessor), 
    Buffer, Arena
  )
{ 
}

TKinokoEventPieceSorter::~TKinokoEventPieceSorter() 
{ 
    delete _Packer;
}

void TKinokoEventPieceSorter::SetLogger(TKinokoBuilderLogger* Logger) 
{ 
    _Sorter.SetLogger(Logger); 
    _Packer->SetLogger(_Logger);
}

void TKinokoEventPieceSorter::ProcessRunBegin(void) 
{ 
    _Sorter.ProcessRunBegin(); 
}

void TKinokoEventPieceSorter::ProcessRunEnd(void) 
{ 
    _Sorter.ProcessRunEnd(); 
}

int TKinokoEventPieceSorter::ProcessPiece(const TKinokoEventPiece& EventPiece) 
{ 
    return _Sorter.ProcessPiece(EventPiece); 
}



class TKinokoEventSegmentStripper: public TKinokoEventPieceProcessor {
  public:
    TKinokoEventSegmentStripper(TKinokoEventSegmentProcessor* OutputSegmentProcessor);
    virtual ~TKinokoEventSegmentStripper();
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize);
    virtual void ProcessEventEnd(void);
    virtual int ProcessPiece(const TKinokoEventPiece& EventPiece);
  protected:
    TKinokoEventSegmentProcessor* _OutputSegmentProcessor;
};


TKinokoEventSegmentStripper::TKinokoEventSegmentStripper(TKinokoEventSegmentProcessor* OutputSegmentProcessor)
{
    _OutputSegmentProcessor = OutputSegmentProcessor;
}

TKinokoEventSegmentStripper::~TKinokoEventSegmentStripper()
{
}

void TKinokoEventSegmentStripper::ProcessRunBegin(void)
{
    _OutputSegmentProcessor->ProcessRunBegin();
}

void TKinokoEventSegmentStripper::ProcessRunEnd(void)
{
    _OutputSegmentProcessor->ProcessRunEnd();
}

void TKinokoEventSegmentStripper::ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize)
{
    _OutputSegmentProcessor->ProcessEventBegin(
	EventKey, PieceType, NumberOfPieces, TotalSize
    );
}

void TKinokoEventSegmentStripper::ProcessEventEnd(void)
{
    _OutputSegmentProcessor->ProcessEventEnd();
}

int TKinokoEventSegmentStripper::ProcessPiece(const TKinokoEventPiece& EventPiece)
{
    TStreamKey StreamKey = EventPiece.ChannelKey;

    TKinokoEventSegment EventSegment(EventPiece);
    EventSegment.SetHeader(
	EventPiece.PieceType, EventSegment.NumberOfPieces(), 
	EventSegment.EventKey()
    );
    EventSegment.StreamKey = StreamKey;

    return _OutputSegmentProcessor->ProcessSegment(EventSegment);
}



TKinokoEventSegmentSorter::TKinokoEventSegmentSorter(TKinokoEventSegmentProcessor* OutputSegmentProcessor, void* Buffer, TKinokoArena& Arena) 
: _Sorter(
    _Stripper = new TKinokoEventSegmentStripper(
	_Consolidator = new TKinokoEventSegmentConsolidator(
	    OutputSegmentProcessor
	)
    ),
    Buffer, Arena
  )
{ 
}

TKinokoEventSegmentSorter::~TKinokoEventSegmentSorter() 
{ 
    delete _Stripper;
    delete _Consolidator;
}

void TKinokoEventSegmentSorter::SetLogger(TKinokoBuilderLogger* Logger) 
{ 
    _Sorter.SetLogger(Logger); 
    _Stripper->SetLogger(Logger);
    _Consolidator->SetLogger(Logger);
}

void TKinokoEventSegmentSorter::ProcessRunBegin(void) 
{ 
    _Sorter.ProcessRunBegin(); 
}

void TKinokoEventSegmentSorter::ProcessRunEnd(void) 
{ 
    _Sorter.ProcessRunEnd(); 
}

int TKinokoEventSegmentSorter::ProcessSegment(const TKinokoEventSegment& EventSegment) 
{ 
    TKinokoEventPiece EventPiece(EventSegment);
    EventPiece.PieceType = EventSegment.PieceType();
    EventPiece.EventKey = EventSegment.EventKey();
    EventPiece.ChannelKey = EventSegment.StreamKey;
    EventPiece.PieceFlag = 0;
    
    return _Sorter.ProcessPiece(EventPiece); 
}
