/* KinokoBuilderCom.hh */
/* Created by Enomoto Sanshiro on 8 September 2009. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#ifndef __KinokoBuilderCom_hh__
#define __KinokoBuilderCom_hh__


#include "KinokoHorizontalBuilder.hh"
#include "KinokoVerticalBuilder.hh"
#include "KinokoBuilderLogger.hh"
#include "KinokoBuilderMonitor.hh"
#include "KinokoStreamPipeComponent.hh"


class TKinokoBuilderCom: public TKinokoStreamPipeComponent {
  public:
    TKinokoBuilderCom(const std::string& TypeName);
    virtual ~TKinokoBuilderCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
    virtual int ProcessSetConfigEvent(TKcomEvent& Event);
  public:
    virtual void SetConfigFile(const std::string& ConfigFileName, const std::string& BuilderName);
    virtual int ProcessSetReportIntervalEvent(TKcomEvent& Event);
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException) = 0;
  protected:
    TKinokoBuilder* _Builder;
    TKinokoBuilderLogger* _BuilderLogger;
    TKinokoBuilderMonitor* _BuilderMonitor;
    std::string _ConfigFileName, _BuilderName;
    int _ReportInterval, _LastReportTime;
    int _NumberOfTransactionsSinceLastReport;
  protected:
    enum TEventId {
	EventId_SetConfig = TKinokoStreamPipeComponent::_NumberOfEvents,
	EventId_SetReportInterval,
	_NumberOfEvents
    };
};


class TKinokoHorizontalBuilderCom: public TKinokoBuilderCom {
  public:
    TKinokoHorizontalBuilderCom(void);
    virtual ~TKinokoHorizontalBuilderCom();
    virtual void SetPieceScanner(TKinokoEventPieceScanner* Scanner);
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException);
  protected:
    TKinokoEventPieceScanner* _Scanner;
};


class TKinokoVerticalBuilderCom: public TKinokoBuilderCom {
  public:
    TKinokoVerticalBuilderCom(void);
    virtual ~TKinokoVerticalBuilderCom();
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException);
};



class TKinokoLoggerBuilderLogger: public TKinokoBuilderLogger {
  public:
    TKinokoLoggerBuilderLogger(const std::string& ComponentName, TKinokoLogger* Logger);
    virtual ~TKinokoLoggerBuilderLogger();
    virtual int Write(const std::string& Message, int MessageLevel);
  protected:
    std::string _Name;
    TKinokoLogger* _Logger;
};


#endif
