/* KinokoComponent.hh */
/* Created by Enomoto Sanshiro on 9 October 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#ifndef __KinokoComponent_hh__
#define __KinokoComponent_hh__


#include <string>
#include "MushTimer.hh"
#include "KcomComponent.hh"
#include "KinokoDefs.hh"


class TKinokoComponent: public TKcomComponent {
  public:
    TKinokoComponent(const std::string& TypeName);
    virtual ~TKinokoComponent();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int DoTransaction(void) throw(TKcomException);
    virtual void OnTransaction(void) throw(TKcomException);
  public:
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
    virtual void EmitKcomEvent(const std::string& EventName, const std::vector<std::string>& EventArgumentList);
    virtual bool EmitKcomEventTo(const std::string& TargetName, const std::string& EventName, const std::vector<std::string>& EventArgumentList, std::string& ReturnValue);
    virtual void UpdateHealthCondition(void);
  private:
    virtual int ProcessSystemEvent(TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessEnableConditionMonitorEvent(TKcomEvent& Event);
  protected:
    TMushRealTimeTimer* _TimeKeeper;
    bool _IsConditionMonitorEnabled;
    long _LastConditionCheckTime;
    long _HeartBeatCount;
    long _VitalLevel;
  protected:
    enum TEventId {
	EventId_Any,
	EventId_System,
	EventId_EnableConditionMonitor,
	_NumberOfEvents
    };
    enum TPropertyId {
	PropertyId_ComponentTypeName,
	PropertyId_Host,
	PropertyId_ConditionCheckTime,
	PropertyId_HeartBeatRate,
	PropertyId_VitalLevel,
	_NumberOfProperties
    };
};


#endif
