/* KinokoDataProcessorCom.cc */
/* Created by Enomoto Sanshiro on 23 April 2001. */
/* Last updated by Enomoto Sanshiro on 21 September 2004. */


#include <string>
#include "KinokoDataProcessor.hh"
#include "KinokoDataProcessorCom.hh"

using namespace std;


TKinokoDataProducerCom::TKinokoDataProducerCom(TKinokoDataProducer* DataProducer)
: TKinokoStreamSourceComponent("KinokoDataProducerCom")
{
    _DataProducer = DataProducer;
}

TKinokoDataProducerCom::~TKinokoDataProducerCom()
{
}

void TKinokoDataProducerCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoStreamSourceComponent::BuildDescriptor(Descriptor);

    Descriptor.AddComment("DataProducer: User Data Process Component");
}

int TKinokoDataProducerCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    return TKinokoStreamSourceComponent::ProcessEvent(
	EventId, Event, EventResponse
    );
}

void TKinokoDataProducerCom::Construct(void) throw(TKinokoException)
{
    _DataProducer->AttachPlatform(
	InputStream(), OutputStream(), _EventEmitter, _Registry, _Logger
    );
    _DataProducer->Construct(
	DataSourceName(), _OutputDataStream, DataSourceId()
    );
}

void TKinokoDataProducerCom::Destruct(void) throw(TKinokoException)
{
    _DataProducer->Destruct();
}

int TKinokoDataProducerCom::ProcessData(void) throw(TKinokoException)
{
    return _DataProducer->ProcessData();
}



TKinokoDataProcessorCom::TKinokoDataProcessorCom(TKinokoDataProcessor* DataProcessor)
: TKinokoStreamPipeComponent("KinokoDataProcessorCom")
{
    _DataProcessor = DataProcessor;
}

TKinokoDataProcessorCom::~TKinokoDataProcessorCom()
{
}

void TKinokoDataProcessorCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoStreamPipeComponent::BuildDescriptor(Descriptor);
    Descriptor.AddComment("DataProcessor: User Data Process Component");
}

int TKinokoDataProcessorCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    return TKinokoStreamPipeComponent::ProcessEvent(
	EventId, Event, EventResponse
    );
}

void TKinokoDataProcessorCom::Construct(void) throw(TKinokoException)
{
    _DataProcessor->AttachPlatform(
	InputStream(), OutputStream(), _EventEmitter, _Registry, _Logger
    );
    _DataProcessor->Construct(
	DataSourceName(), _InputDataStream, _OutputDataStream, DataSourceId()
    );
    _DataProcessor->SetStreamCommandProcessor(_StreamCommandProcessor);
}

void TKinokoDataProcessorCom::Destruct(void) throw(TKinokoException)
{
    _DataProcessor->Destruct();
}

int TKinokoDataProcessorCom::ProcessData(void) throw(TKinokoException)
{
    int Result = _DataProcessor->ProcessData();
    if (Result <= 0) {
        _TimeKeeper->Suspend();
    }

    return Result;
}



TKinokoDataConsumerCom::TKinokoDataConsumerCom(TKinokoDataConsumer* DataConsumer)
: TKinokoStreamSinkComponent("KinokoDataConsumerCom")
{
    _DataConsumer = DataConsumer;
}

TKinokoDataConsumerCom::~TKinokoDataConsumerCom()
{
}

void TKinokoDataConsumerCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoStreamSinkComponent::BuildDescriptor(Descriptor);
    Descriptor.AddComment("DataConsumer: User Data Process Component");
}

int TKinokoDataConsumerCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    return TKinokoStreamSinkComponent::ProcessEvent(
	EventId, Event, EventResponse
    );
}

void TKinokoDataConsumerCom::Construct(void) throw(TKinokoException)
{
    string Name = ComponentName();
    _DataConsumer->AttachPlatform(
	InputStream(), OutputStream(), _EventEmitter, _Registry, _Logger
    );
    _DataConsumer->Construct(Name, _InputDataStream);
    _DataConsumer->SetStreamCommandProcessor(_StreamCommandProcessor);
}

void TKinokoDataConsumerCom::Destruct(void) throw(TKinokoException)
{
    _DataConsumer->Destruct();
}

int TKinokoDataConsumerCom::ProcessData(void) throw(TKinokoException)
{
    int Result = _DataConsumer->ProcessData();
    if (Result <= 0) {
        _TimeKeeper->Suspend();
    }

    return Result;
}
