/* KinokoLoggerCom.hh */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#ifndef __KinokoLoggerCom_hh__
#define __KinokoLoggerCom_hh__


#include <string>
#include "KorbObjectMessenger.hh"
#include "KinokoLogger.hh"
#include "KinokoSystemComponent.hh"


class TKinokoLoggerCom: public TKinokoSystemComponent {
  public:
    TKinokoLoggerCom(void);
    virtual ~TKinokoLoggerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
  public:
    virtual void OnRemarkable(const std::string& Message);
    virtual void OnWarning(const std::string& Message);
    virtual void OnError(const std::string& Message);
    virtual void OnPanic(const std::string& Message);
  protected:
    virtual int ProcessStartLoggingEvent(TKcomEvent& Event);
    virtual int ProcessRestartLoggingEvent(TKcomEvent& Event);
    virtual int ProcessClearStatusEvent(TKcomEvent& Event);
    virtual int ProcessQuitEvent(TKcomEvent& Event);
    virtual int ProcessWriteDebugEvent(TKcomEvent& Event);
    virtual int ProcessWriteNoticeEvent(TKcomEvent& Event);
    virtual int ProcessWriteRemarkableEvent(TKcomEvent& Event);
    virtual int ProcessWriteWarningEvent(TKcomEvent& Event);
    virtual int ProcessWriteErrorEvent(TKcomEvent& Event);
    virtual int ProcessWritePanicEvent(TKcomEvent& Event);
  protected:
    enum TEventId {
	EventId_StartLogging = TKinokoSystemComponent::_NumberOfEvents,
	EventId_RestartLogging,
	EventId_ClearStatus,
	EventId_WriteDebug,
	EventId_WriteNotice,
	EventId_WriteRemarkable,
	EventId_WriteWarning,
	EventId_WriteError,
	EventId_WritePanic,
	EventId_ProcessRemarkable,
	EventId_ProcessWarning,
	EventId_ProcessError,
	EventId_ProcessPanic,
	_NumberOfEvents
    };
  protected:
    TKinokoKoapLogger* _Logger;
    TKinokoLogFile* _LogFile;
    TKorbObjectMessenger* _ObjectMessenger;
    TKinokoLogMessageHandler* _LogMessageHandler;
    bool _IsRunning;
};


#endif
