/* KinokoStandalineBuilder.hh */
/* Edited by Enomoto Sanshiro on 28 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#include "MushArgumentList.hh"
#include "KinokoHorizontalBuilder.hh"
#include "KinokoVerticalBuilder.hh"


class TKinokoStandaloneBuilder {
  public:
    TKinokoStandaloneBuilder(int argc, char** argv);
    virtual ~TKinokoStandaloneBuilder();
    virtual int Start(void) throw(TKinokoException);
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException) = 0;
  protected:
    TMushArgumentList _ArgumentList;
};


class TKinokoStandaloneHorizontalBuilder: public TKinokoStandaloneBuilder {
  public:
    TKinokoStandaloneHorizontalBuilder(int argc, char** argv);
    virtual ~TKinokoStandaloneHorizontalBuilder();
    virtual void SetPieceScanner(TKinokoEventPieceScanner* Scanner);
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException);
  protected:
    TKinokoEventPieceScanner* _Scanner;
};


class TKinokoStandaloneVerticalBuilder: public TKinokoStandaloneBuilder {
  public:
    TKinokoStandaloneVerticalBuilder(int argc, char** argv);
    virtual ~TKinokoStandaloneVerticalBuilder();
  protected:
    virtual TKinokoBuilder* CreateBuilder(void) throw(TKinokoException);
};
