/* KinokoStandaloneComponent.hh */
/* Created by Enomoto Sanshiro on 9 August 2001. */
/* Last updated by Enomoto Sanshiro on 21 September 2004. */


#ifndef __KinokoStandaloneComponent_hh__
#define __KinokoStandaloneComponent_hh__


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "MushSocket.hh"
#include "MushTimer.hh"
#include "MushMisc.hh"
#include "KinokoPlatform.hh"
#include "KinokoLogger.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoKdfStorage.hh"
#include "KinokoDataProcessor.hh"



class TKinokoStandaloneComponent {
  public:
    TKinokoStandaloneComponent(const std::string& Name, int DataSourceId = 0);
    virtual ~TKinokoStandaloneComponent();
    virtual void Start(TMushArgumentList& ArgumentList) throw(TKinokoException);
  protected:
    virtual void OpenStreamFile(TMushArgumentList& ArgumentList) throw(TKinokoException) = 0;
    virtual void Construct(void) throw(TKinokoException) = 0;
    virtual void Destruct(void) throw(TKinokoException) = 0;
    virtual int ProcessData(void) throw(TKinokoException) = 0;
  protected:
    int _DataSourceId;
    std::string _Name;
    std::istream* _InputStream;
    std::ostream* _OutputStream;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    TKinokoLogger* _Logger;
  private:
    TMushServerSocket* _StreamSocket;
    std::istream* _InputSocketStream;
    std::ostream* _OutputSocketStream;
    TMushIntervalTimer* _DelayTimer;
};


class TKinokoStandaloneDataProcessor: public TKinokoStandaloneComponent {
  public:
    TKinokoStandaloneDataProcessor(TKinokoDataProcessor* DataProcessor, const std::string& Name, int DataSourceId = 0);
    virtual ~TKinokoStandaloneDataProcessor();
  protected:
    virtual void OpenStreamFile(TMushArgumentList& ArgumentList) throw(TKinokoException);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataProcessor* _DataProcessor;
    std::string _InputFileName;
    std::string _OutputFileName;
    TKinokoStorage* _InputDataStorage;
    TKinokoStorage* _OutputDataStorage;
    TKinokoInputStream* _InputDataStream;
    TKinokoOutputStream* _OutputDataStream;
};


class TKinokoStandaloneDataProducer: public TKinokoStandaloneComponent {
  public:
    TKinokoStandaloneDataProducer(TKinokoDataProducer* DataProducer, const std::string& Name, int DataSourceId = 0);
    virtual ~TKinokoStandaloneDataProducer();
  protected:
    virtual void OpenStreamFile(TMushArgumentList& ArgumentList) throw(TKinokoException);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataProducer* _DataProducer;
    std::string _OutputFileName;
    TKinokoStorage* _OutputDataStorage;
    TKinokoOutputStream* _OutputDataStream;
};


class TKinokoStandaloneDataConsumer: public TKinokoStandaloneComponent {
  public:
    TKinokoStandaloneDataConsumer(TKinokoDataConsumer* DataConsumer, const std::string& Name);
    virtual ~TKinokoStandaloneDataConsumer();
  protected:
    virtual void OpenStreamFile(TMushArgumentList& ArgumentList) throw(TKinokoException);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataConsumer* _DataConsumer;
    std::string _InputFileName;
    TKinokoStorage* _InputDataStorage;
    TKinokoInputStream* _InputDataStream;
};


#endif
