/* KinokoStreamSourceComponent.hh */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 12 October 2000. */


#ifndef __KinokoStreamSourceComponent_hh__
#define __KinokoStreamSourceComponent_hh__


#include <string>
#include "KinokoActiveStreamComponent.hh"


class TKinokoStreamSourceComponent: public TKinokoActiveStreamComponent {
  public:
    TKinokoStreamSourceComponent(const std::string& TypeName);
    virtual ~TKinokoStreamSourceComponent();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  private:
    virtual int ProcessStartEvent(TKcomEvent& Event) throw(TKinokoException);
    virtual int ProcessStopEvent(TKcomEvent& Event) throw(TKinokoException);
    virtual int ProcessSetDataSourceNameEvent(TKcomEvent& Event) throw(TKinokoException);
    virtual int ProcessSetDataSourceIdEvent(TKcomEvent& Event) throw(TKinokoException);
  protected:
    virtual void SetProperties(void) throw(TKinokoException);
  protected:
    virtual std::string DataSourceName(void);
    virtual int DataSourceId(void);
  protected:
    enum TEventId {
	EventId_Start = TKinokoActiveStreamComponent::_NumberOfEvents,
	EventId_Stop,
	EventId_SetDataSourceName,
	EventId_SetDataSourceId,
	_NumberOfEvents
    };
  protected:
    std::string _SpecifiedDataSourceName;
    int _SpecifiedDataSourceId;
};


#endif
