/* KinokoConsole.hh */
/* Created by Enomoto Sanshiro on 23 August 2002. */
/* Last updated by Enomoto Sanshiro on 23 August 2002. */


#ifndef __KinokoController_hh__
#define __KinokoController_hh__


#include <string>
#include <vector>
#include "MushThread.hh"
#include "KinokoPlatform.hh"
#include "KinokoControlScript.hh"


class TKinokoConsole {
  public:
    TKinokoConsole(std::istream& InputStream, std::ostream& OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry, TKinokoTerminal* Terminal);
    virtual ~TKinokoConsole();
    virtual int ProcessInput(void);
    virtual void Print(const std::string& Message);
    virtual void Execute(const std::string& CommandFileName) throw(TScriptException);
    virtual void Quit(void);
  protected:
    virtual void ProcessScript(void) throw(TScriptException);
    virtual void ProcessCommand(void) throw(TScriptException);
  protected:
    std::istream& _InputStream;
    std::ostream& _OutputStream;
    TKinokoRegistry* _Registry;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoTerminal* _Terminal;
    TKinokoControlScript* _Script;
    bool _IsStopRequested;
  private:
    TParaTokenTable* _TokenTable;
    TParaSymbolTable* _SymbolTable;
    TParaPackage* _Package;
    TParaStatementParser* _StatementParser;
    TParaTokenizer* _Tokenizer;
    std::vector<TParaPackageEntry*> _EntryList;
    std::vector<std::ifstream*> _InputStreamList;
    TParaValue _LastResult;
};


class TKinokoThreadedConsole: public TKinokoConsole, public TMushThread {
  public:
    TKinokoThreadedConsole(std::istream& InputStream, std::ostream& OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry, TKinokoTerminal* Terminal);
    virtual ~TKinokoThreadedConsole();
    virtual void Run(void);
    virtual void Quit(void);
  protected:
    TMushThreadCondition* _Condition;
};


#endif
