/* KinokoControlInputWatcher.hh */
/* Created by Enomoto Sanshiro on 7 December 2000. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#ifndef __KinokoControlInputWatcher_hh__
#define __KinokoControlInputWatcher_hh__


#include <iostream>
#include <string>
#include "MushThread.hh"


class TKinokoControlInputWatcher: public TMushThread {
  public:
    TKinokoControlInputWatcher(std::istream& InputStream, char LineTerminator = '\n');
    virtual ~TKinokoControlInputWatcher();
    virtual void Run(void);
    virtual void Stop(void);
    virtual bool IsDataAvailable(void);
    virtual bool WaitData(long TimeOut_Sec = 0);
    virtual const std::string& Line(void);
    virtual void Flush(void);
  protected:
    std::istream& _InputStream;
    char _LineTerminator;
    std::string _Line;
    TMushThreadCondition* _DataAvailableCondition;
    TMushThreadCondition* _DataProcessedCondition;
    bool _IsDataAvailable;
    bool _IsStopRequested;
};


#endif
