/* KinokoController.hh */
/* Created by Enomoto Sanshiro on 7 December 2000. */
/* Last updated by Enomoto Sanshiro on 9 August 2007. */


#ifndef __KinokoController_hh__
#define __KinokoController_hh__


#include <string>
#include <vector>
#include "KinokoPlatform.hh"
#include "KinokoControlInputWatcher.hh"


class TKinokoController {
  public:
    TKinokoController(std::istream& InputStream, std::ostream& OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoController();
    virtual int ProcessInput(void);
    virtual void Quit(void);
  public:
    virtual void Open(const std::string& FileName);
    virtual void ChangeState(const std::string& StateName);
    virtual void SetWidgetValue(const std::string& WidgetName, const std::string& Value);
    virtual void SetWidgetAttribute(const std::string& WidgetName, const std::string& AttributeName, const std::string& Value);
    virtual void ExecuteAction(const std::string& ActionName, const std::vector<std::string>& ArgumentList);
    virtual void OpenPopup(const std::string& Type, const std::string& ActionList, const std::string& Message);
    virtual std::string OpenQueryPopup(const std::string& Type, const std::string& ActionList, const std::string& Message);
    virtual void Save(const std::string& FileName);
    virtual void Load(const std::string& FileName);
    virtual void LoadScript(const std::string& ScriptFileName);
  protected:
    virtual void ProcessCommand(const std::string& Line);
    virtual std::string DecodeEscape(const std::string& Value);
  protected:
    std::istream& _InputStream;
    std::ostream& _OutputStream;
    TKinokoRegistry* _Registry;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoControlInputWatcher* _InputWatcher;
};


#endif
