/* KinokoLogger.hh */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 7 March 2002. */


#ifndef __KinokoLogger_hh__
#define __KinokoLogger_hh__


#include <iostream>
#include <fstream>
#include <string>
#include <vector>


class TKinokoLogMessageHandler;
class TKinokoLogFile;


class TKinokoLogMessage {
  public:
    enum TLogLevel {
	LogLevel_Debug,
	LogLevel_Notice,
	LogLevel_Remarkable,
	LogLevel_Warning,
	LogLevel_Error,
	LogLevel_Panic,
	_NumberOfLogLevels
    };
  public:
    TKinokoLogMessage(int LogLevel, const std::string& Source, const std::string& Contents);
    ~TKinokoLogMessage();
    int LogLevel(void) const;
    const std::string& LogLevelName(void) const;
    const std::string& LogLevelSymbol(void) const;
    const std::string& Date(void) const;
    const std::string& Source(void) const;
    const std::string& Contents(void) const;
    std::string Message(void) const;
    std::string LongMessage(void) const;
  protected:
    int _LogLevel;
    std::string _LogLevelName;
    std::string _LogLevelSymbol;
    std::string _Date;
    std::string _Source;
    std::string _Contents;
};



class TKinokoLogger {
  public:
    TKinokoLogger(std::ostream* OutputStream);
    virtual ~TKinokoLogger();
    virtual void SetLogFile(TKinokoLogFile* LogFile);
    virtual void Refresh(void);
    virtual void ClearStatus(void);
    virtual void AddMessageHandler(TKinokoLogMessageHandler* Handler);
    virtual int Write(int LogLevel, const std::string& Source, const std::string& Contents);
    virtual int WriteDebug(const std::string& Source, const std::string& Contents);
    virtual int WriteNotice(const std::string& Source, const std::string& Contents);
    virtual int WriteRemarkable(const std::string& Source, const std::string& Contents);
    virtual int WriteWarning(const std::string& Source, const std::string& Contents);
    virtual int WriteError(const std::string& Source, const std::string& Contents);
    virtual int WritePanic(const std::string& Source, const std::string& Contents);
  protected:
    virtual void ProcessLogMessage(const TKinokoLogMessage& LogMessage);
  protected:
    std::ostream* _OutputStream;
    TKinokoLogFile* _LogFile;
    std::vector<TKinokoLogMessageHandler*> _MessageHandlerList;
};


class TKinokoKoapLogger: public TKinokoLogger {
  public:
    TKinokoKoapLogger(std::ostream* OutputStream);
    virtual ~TKinokoKoapLogger();
    virtual void Refresh(void);
    virtual void ClearStatus(void);
  protected:
    virtual void ProcessLogMessage(const TKinokoLogMessage& LogMessage);
  protected:
    std::string _StatusBarMessage;
};


class TKinokoLogMessageHandler {
  public:
    TKinokoLogMessageHandler(void);
    virtual ~TKinokoLogMessageHandler();
    virtual void ProcessLogMessage(const TKinokoLogMessage& LogMessage);
  protected:
    virtual void OnDebug(const std::string& Message) {}
    virtual void OnNotice(const std::string& Message) {}
    virtual void OnRemarkable(const std::string& Message) {}
    virtual void OnWarning(const std::string& Message) {}
    virtual void OnError(const std::string& Message) {}
    virtual void OnPanic(const std::string& Message) {}
};


class TKinokoLogFile {
  public:
    TKinokoLogFile(void);
    virtual ~TKinokoLogFile();
    virtual void Open(const std::string& FileName);
    virtual void Close(void);
    virtual void Write(const TKinokoLogMessage& LogMessage);
  protected:
    std::string _FileName;
    std::ostream* _File;
};


class TKinokoXmlLogFile: public TKinokoLogFile {
  public:
    TKinokoXmlLogFile(void);
    virtual ~TKinokoXmlLogFile();
    virtual void Open(const std::string& FileName);
    virtual void Close(void);
    virtual void Write(const TKinokoLogMessage& LogMessage);
  protected:
    int _CloseTagLength;
};


#endif

