/* KinokoLoggerOrb.cc */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#include <iostream>
#include "MushMisc.hh"
#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "KinokoLogger.hh"
#include "KinokoLoggerOrb.hh"

using namespace std;


static const char* LoggerClassName = "KinokoLogger";


TKinokoLoggerProxy::TKinokoLoggerProxy(TKorbOrb* Orb)
: TKorbObjectProxy(LoggerClassName, Orb), TKinokoLogger(0)
{
}

TKinokoLoggerProxy::~TKinokoLoggerProxy()
{
}

int TKinokoLoggerProxy::Write(int LogLevel, const string& Name, const string& Contents)
{
    int MethodId = TKinokoLoggerMessenger::MethodId_Write;
    TKorbOrbPacket OrbPacket = CreateOrbPacket(MethodId);
    OrbPacket.IsOneWay() = 1;

    OrbPacket.ArgumentSerializer().PutLong((long) LogLevel);
    OrbPacket.ArgumentSerializer().PutString(Name);
    OrbPacket.ArgumentSerializer().PutString(Contents);

    try {
	InvokeMethod(OrbPacket);
    }
    catch (TKorbException& e) {
	throw e;
    }

    return 0;
}



TKinokoLoggerMessenger::TKinokoLoggerMessenger(TKinokoLogger* Logger)
: TKorbObjectMessenger(LoggerClassName)
{
    _Logger = Logger;
}

TKinokoLoggerMessenger::~TKinokoLoggerMessenger()
{
}

int TKinokoLoggerMessenger::DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException)
{
    if (OrbPacket.MethodId() == MethodId_Write) {
	long LogLevel;
	string Name; string Contents;

	OrbPacket.ArgumentSerializer().GetLong(LogLevel);
	OrbPacket.ArgumentSerializer().GetString(Name);
	OrbPacket.ArgumentSerializer().GetString(Contents);

	int Result = _Logger->Write(LogLevel, Name, Contents);

	OrbPacket.ArgumentSerializer().Rewind();
	OrbPacket.ArgumentSerializer().PutInt(Result);
    }
    else {
	return 0;
    }

    return 1;
}
