/* KinokoBlockDataSection.cc */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#include <iostream>
#include <string>
#include "ParaTokenizer.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoBlockDataSection.hh"

using namespace std;


TKinokoBlockDataSection::TKinokoBlockDataSection(TKinokoDataSource* DataSource, const string& SectionName)
: TKinokoDataSection(DataSource, SectionName)
{
    _Formatter = 0;
    _Scanner = 0;
}

TKinokoBlockDataSection::TKinokoBlockDataSection(TKinokoDataSource* DataSource, const string& SectionName, int SectionId)
: TKinokoDataSection(DataSource, SectionName, SectionId)
{
    _Formatter = 0;
    _Scanner = 0;
}

TKinokoBlockDataSection::~TKinokoBlockDataSection()
{
    delete _Formatter;
    delete _Scanner;
}

int TKinokoBlockDataSection::SectionType(void) const
{
    return TKinokoDataSection::SectionType_Block;
}

void TKinokoBlockDataSection::ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException)
{
    try {
	TParaToken Token = Tokenizer.Next();
	if (Token.Is("{")) {
	    while ((Token = Tokenizer.Next()).IsNot("}")) {
		if (Token.Is("attribute")) {
		    Tokenizer.Unget(Token);
		    ReadAttribute(Tokenizer);
		}
		else {
		    Tokenizer.Unget(Token);
		    TKinokoDataSource::SkipUnknownEntry(Tokenizer);
		}
	    }
	}
	else {
	    Token.MustBe(";");
	}
    }
    catch (TScriptException &e) {
	throw TKinokoException(
	    "TKinokoBlockDataSection::ReadFrom()",
	    "script exception: " + e.Message()
	);
    }
}

void TKinokoBlockDataSection::WriteTo(ostream& os, const string& Indent)
{
    os << Indent << "section \"" << _SectionName << "\"<" << _SectionId << ">";
    os << ": block";


#if USE_KDF2
    os << ";" << endl;
#else
    os << " {" << endl;
    WriteAttributeList(os, Indent + "    ");
    os << Indent << "}" << endl;
#endif
}



TKinokoBlockDataSectionFormatter::TKinokoBlockDataSectionFormatter(TKinokoBlockDataSection* DataSection)
: TKinokoDataSectionFormatter(DataSection)
{
}

TKinokoBlockDataSectionFormatter::~TKinokoBlockDataSectionFormatter()
{
}



TKinokoBlockDataSectionScanner::TKinokoBlockDataSectionScanner(TKinokoBlockDataSection* DataSection)
{
}

TKinokoBlockDataSectionScanner::~TKinokoBlockDataSectionScanner()
{
}
