/* KinokoDataStreamFormatter.cc */
/* Created by Enomoto Sanshiro on 23 November 2000. */
/* Last updated by Enomoto Sanshiro on 23 November 2000. */


#include <sstream>
#include "MushDataEncoder.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataStreamFormatter.hh"

using namespace std;


TKinokoDataStreamFormatter::TKinokoDataStreamFormatter(TKinokoDataSource* DataSource)
{
    _DataSource = DataSource;
    _DataSourceId = DataSource->DataSourceId();

    _DescriptorLength = 0;
}

TKinokoDataStreamFormatter::~TKinokoDataStreamFormatter()
{
}

int TKinokoDataStreamFormatter::DescriptorPacketSize(void)
{
    //... temporary ...//
    if (_DescriptorLength == 0) {
	ostringstream DescriptorStream;
	_DataSource->WriteTo(DescriptorStream);
	_DescriptorLength = (DescriptorStream.str().size() / 4 + 1) * 4;
    }

    return sizeof(U32bit) * Offset_Contents + _DescriptorLength;
}

void TKinokoDataStreamFormatter::WriteDescriptor(void* Buffer)
{
    if (_DescriptorLength == 0) {
	return;
    }

    ((U32bit*) Buffer)[Offset_DataSourceId] = _DataSourceId & DataSourceIdMask;
    ((U32bit*) Buffer)[Offset_PacketType] = PacketType_DataDescriptor;

    ostringstream DescriptorStream;
    _DataSource->WriteTo(DescriptorStream);

    char* Base = (char*) ((U32bit*) Buffer + Offset_Contents);
    strcpy(Base, DescriptorStream.str().c_str());
}



TMushBinaryDataEncoder* TKinokoDataStreamScanner::_DataEncoder = 0;

TKinokoDataStreamScanner::TKinokoDataStreamScanner(void)
{
}

TKinokoDataStreamScanner::~TKinokoDataStreamScanner()
{
}

void TKinokoDataStreamScanner::CorrectByteOrder(void* Buffer, int BufferSize)
{
    if (! IsByteOrderReversed(Buffer)) {
	return;
    }

    if (_DataEncoder == 0) {
	_DataEncoder = new TMushBinaryDataEncoder(sizeof(U32bit), true);
    }

    int HeaderSize = Offset_Contents * sizeof(U32bit);
    _DataEncoder->DecodeOn(Buffer, HeaderSize);
    
    if (IsDataPacket(Buffer)) {
	void* Contents = ((U32bit*) Buffer) + Offset_Contents;
	_DataEncoder->DecodeOn(Contents, BufferSize - HeaderSize);
    }
}


string TKinokoDataStreamScanner::CommandNameOf(int CommandValue)
{
    string CommandName;

    switch (CommandValue) {
      case TKinokoDataStreamScanner::Command_RunBegin:
	CommandName = "RUN_BEGIN";
	break;
      case TKinokoDataStreamScanner::Command_RunEnd:
	CommandName = "RUN_END";
	break;
      case TKinokoDataStreamScanner::Command_RunSuspend:
	CommandName = "RUN_SUSPEND";
	break;
      case TKinokoDataStreamScanner::Command_RunResume:
	CommandName = "RUN_RESUME";
	break;
      case TKinokoDataStreamScanner::Command_ClockTick:
	CommandName = "CLOCK_TICK";
	break;
      case TKinokoDataStreamFormatter::Command_Clear:
	CommandName = "CLEAR";
	break;
      case TKinokoDataStreamFormatter::Command_Update:
	CommandName = "UPDATE";
	break;
      case TKinokoDataStreamFormatter::Command_Flush:
	CommandName = "FLUSH";
	break;
      case TKinokoDataStreamFormatter::Command_Strobe:
	CommandName = "STROBE";
	break;
      case TKinokoDataStreamFormatter::Command_Synchronize:
	CommandName = "SYNCHRONIZE";
	break;
      case TKinokoDataStreamFormatter::Command_Build:
	CommandName = "BUILD";
	break;
      case TKinokoDataStreamFormatter::Command_Wait:
	CommandName = "WAIT";
	break;
      case TKinokoDataStreamFormatter::Command_Hold:
	CommandName = "HOLD";
	break;
      case TKinokoDataStreamFormatter::Command_Release:
	CommandName = "RELEASE";
	break;
      case TKinokoDataStreamFormatter::Command_Next:
	CommandName = "NEXT";
	break;
      case TKinokoDataStreamFormatter::Command_Skip:
	CommandName = "SKIP";
	break;
      case TKinokoDataStreamFormatter::Command_Break:
	CommandName = "BREAK";
	break;
      case TKinokoDataStreamFormatter::Command_Sleep:
	CommandName = "SLEEP";
	break;
      case TKinokoDataStreamFormatter::Command_Wake:
	CommandName = "WAKE";
	break;
      case TKinokoDataStreamFormatter::Command_Switch:
	CommandName = "SWITCH";
	break;
      case TKinokoDataStreamFormatter::Command_Restore:
	CommandName = "RESTORE";
	break;
      default:
	CommandName = "UNKNOWN";
	break;
    }

    return CommandName;
}    


TKinokoStreamCommandProcessor::TKinokoStreamCommandProcessor(void)
{
    _NumberOfRunningDataSources = 0;
    _NumberOfSuspendingDataSources = 0;
}

TKinokoStreamCommandProcessor::~TKinokoStreamCommandProcessor()
{
}

void TKinokoStreamCommandProcessor::ProcessCommand(int CommandValue)
{
    if (CommandValue == TKinokoDataStreamScanner::Command_RunBegin) {
        _NumberOfRunningDataSources++;
	OnReceiveRunBeginPacket();
	if (_NumberOfRunningDataSources == 1) {
	    OnReceiveFirstRunBeginPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunEnd) {
        _NumberOfRunningDataSources--;
	OnReceiveRunEndPacket();
	if (_NumberOfRunningDataSources == 0) {
	    OnReceiveLastRunEndPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunSuspend) {
        _NumberOfSuspendingDataSources++;
	OnReceiveRunSuspendPacket();
	if (_NumberOfSuspendingDataSources == _NumberOfRunningDataSources) {
	    OnReceiveLastRunSuspendPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunResume) {
        _NumberOfSuspendingDataSources--;
	OnReceiveRunResumePacket();
	if (_NumberOfSuspendingDataSources == _NumberOfRunningDataSources - 1) {
	    OnReceiveFirstRunResumePacket();
	}
    }
}
