/* KinokoControllerMessenger.hh */
/* Created by Enomoto Sanshiro on 8 October 1999. */
/* Last updated by Enomoto Sanshiro on 30 September 2002. */


#ifndef __KinokoControllerMessenger_hh__
#define __KinokoControllerMessenger_hh__


#include <string>
#include <vector>
#include "ParaObject.hh"
#include "RoomVmeAccess.hh"
#include "RoomCamacAccess.hh"
#include "RoomVmeBridge.hh"
#include "RoomNetworkBridge.hh"
#include "KinokoDaqBuilder.hh"
#include "KinokoModuleMessenger.hh"


class TKinokoVmeCrateMessenger;
class TKinokoCamacCrateMessenger;


class TKinokoVmeControllerMessenger: public TParaObjectPrototype {
  public:
    TKinokoVmeControllerMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoVmeControllerMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int InvokeMethodByName(const std::string& MethodName, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual std::string ControllerName(void);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    friend class TKinokoVmeCrateMessenger; 
    TRoomVmeController* _VmeController;
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _ControllerName;
};


class TKinokoCamacControllerMessenger: public TParaObjectPrototype {
  public:
    TKinokoCamacControllerMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoCamacControllerMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int InvokeMethodByName(const std::string& MethodName, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual std::string ControllerName(void);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Initialize(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Clear(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue SetInhibit(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue ReleaseInhibit(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    friend class TKinokoCamacCrateMessenger;
    friend class TKinokoVmeCamacBridgeMessenger;
    friend class TKinokoNetworkCamacBridgeMessenger;
    TRoomCamacController* _CamacController;
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _ControllerName;
};


class TKinokoVmeCamacBridgeMessenger: public TKinokoCamacControllerMessenger {
  public:
    TKinokoVmeCamacBridgeMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoVmeCamacBridgeMessenger();
    virtual TParaObjectPrototype* Clone(void);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    friend class TKinokoVmeCrateMessenger;
    TRoomVmeModule* _VmeModule;
};


class TKinokoNetworkCamacBridgeMessenger: public TKinokoCamacControllerMessenger {
  public:
    TKinokoNetworkCamacBridgeMessenger(TKinokoDaqBuilder* DaqBuilder, bool IsScriptTest);
    virtual ~TKinokoNetworkCamacBridgeMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int InvokeMethodByName(const std::string& MethodName, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Connect(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    TRoomNetworkModule* _NetworkModule;
    bool _IsScriptTest;
};


class TKinokoVmeCrateMessenger: public TParaObjectPrototype {
  public:
    TKinokoVmeCrateMessenger(TKinokoDaqBuilder* DaqBuilder, bool IsScriptTest = false);
    virtual ~TKinokoVmeCrateMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int InvokeMethodByName(const std::string& MethodName, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue InstallController(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue InstallModule(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    TRoomVmeCrate* _VmeCrate;
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _CrateName;
    bool _IsScriptTest;
};


class TKinokoCamacCrateMessenger: public TParaObjectPrototype {
  public:
    TKinokoCamacCrateMessenger(TKinokoDaqBuilder* DaqBuilder, bool IsScriptTest = false);
    virtual ~TKinokoCamacCrateMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int InvokeMethodByName(const std::string& MethodName, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue InstallController(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue InstallModule(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    TRoomCamacCrate* _CamacCrate;
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _CrateName;
    bool _IsScriptTest;
};


#endif
