/* KinokoDaqFrontend.hh */
/* Created by Enomoto Sanshiro on 8 July 2001. */
/* Last updated by Enomoto Sanshiro on 29 March 2002. */


#ifndef __KinokoDaqFrontend_hh__
#define __KinokoDaqFrontend_hh__


#include <string>
#include "KinokoScriptedDaqBuilder.hh"
#include "KinokoDevicePool.hh"
#include "KinokoTrigger.hh"
#include "KinokoTransaction.hh"


class TKinokoDaqFrontend {
  public:
    TKinokoDaqFrontend(const std::string& Name);
    virtual ~TKinokoDaqFrontend();
    virtual void Construct(const std::string& ScriptFileName, const std::string& DataSourceName, int DataSourceId, TKinokoOutputStream* OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual void OnStart(void) throw(TKinokoException);
    virtual void OnStop(void) throw(TKinokoException);
    virtual int DoTransaction(void) throw(TKinokoException);
    virtual int ExecuteDaqCommand(const std::string& Message, int* ParameterList, int NumberOfParameters) throw(TKinokoException);
    virtual bool IsStopRequested(void);
  protected:
    std::string _Name;
    TKinokoScriptedDaqBuilder* _DaqBuilder;
    TKinokoDevicePool* _DevicePool;
    TKinokoTrigger* _Trigger;
    TKinokoTransaction* _Transaction;
};


class TKinokoNullDaqFrontend: public TKinokoDaqFrontend {
  public:
    TKinokoNullDaqFrontend(void);
    virtual ~TKinokoNullDaqFrontend();
    virtual void Construct(const std::string& ScriptFileName, const std::string& DataSourceName, int DataSourceId, TKinokoOutputStream* OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual void OnStart(void) throw(TKinokoException);
    virtual void OnStop(void) throw(TKinokoException);
    virtual int DoTransaction(void) throw(TKinokoException);
    virtual int ExecuteDaqCommand(const std::string& Message, int* ParameterList, int NumberOfParameters) throw(TKinokoException);
    virtual bool IsStopRequested(void);
};


#endif
