/* KinokoDataRecord.cc */
/* Created by Enomoto Sanshiro on 20 July 2001. */
/* Last updated by Enomoto Sanshiro on 13 July 2007. */


#include <string>
#include "KinokoTaggedDataSection.hh"
#include "KinokoDataRecord.hh"

using namespace std;


TKinokoDataRecord::TKinokoDataRecord(TKinokoTaggedDataSection* DataSection)
{
    _DataSection = DataSection;
    _DataArea = 0;
}

TKinokoDataRecord::~TKinokoDataRecord()
{
    delete[] _DataArea;
}

int TKinokoDataRecord::AddField(const string& FieldName, int Width, int FieldValueType, const string& PrintFormat)
{
    int FieldIndex;

    if (_DataSection->HasField(FieldName)) {
	FieldIndex = _DataSection->FieldIndexOf(FieldName);
    }
    else {
	FieldIndex = _DataSection->AddField(
	    FieldName, Width, FieldValueType, PrintFormat
	);
    }

    return FieldIndex;
}

void TKinokoDataRecord::AddFieldValueAlias(int FieldIndex, int Value, const std::string& Name)
{
    TKinokoTaggedDataSection::TValueNameTable& Table = (
	_DataSection->FieldValueNameTableOf(FieldIndex)
    );

    if (Table.count(Value) > 0) {
	Table[Value] += " or ";
    }

    Table[Value] += Name;
}

void TKinokoDataRecord::Initialize(void)
{
    if (_DataArea != 0) {
	return;
    }

    _NumberOfFields = _DataSection->NumberOfFields();
    _DataArea = new int[_NumberOfFields];
    
    _Formatter = _DataSection->Formatter();
    
    _DataAreaSize = _Formatter->DataSize();
    _PacketSize = _Formatter->PacketSizeFor(_DataAreaSize);
}

void TKinokoDataRecord::FillField(int Index, int Value)
{
    _DataArea[Index] = Value;
}

void TKinokoDataRecord::Clear(void)
{
    for (int Index = 0; Index < _NumberOfFields; Index++) {
	_DataArea[Index] = 0;
    }
}

int TKinokoDataRecord::PacketSize(void)
{
    return _PacketSize;
}

int TKinokoDataRecord::WriteTo(void* Buffer)
{
    for (int Index = 0; Index < _NumberOfFields; Index++) {
	_Formatter->WriteTo(Buffer, Index, _DataArea[Index]);
    }
    _Formatter->WriteHeaderTo(Buffer, _DataAreaSize);

    return _PacketSize;
}

const string& TKinokoDataRecord::Name(void)
{
    return _DataSection->SectionName();
}

void TKinokoDataRecord::Dump(std::ostream& os)
{
    for (int Index = 0; Index < _NumberOfFields; Index++) {
	os << _DataSection->SectionName() << " ";
	os << _DataSection->FieldNameOf(Index) << " ";
	os << _DataArea[Index] << endl;
    }
}
