/* KinokoDevicePool.hh */
/* Created by Enomoto Sanshiro on 16 April 1999. */
/* Last updated by Enomoto Sanshiro on 30 November 2000. */


#ifndef __KinokoDevicePool_hh__
#define __KinokoDevicePool_hh__


#include <string>
#include <map>
#include "RoomModule.hh"
#include "RoomDeviceBase.hh"
#include "KinokoDefs.hh"
#include "KinokoDataRecord.hh"


class TKinokoDevicePool {
  public:
    TKinokoDevicePool(void);
    virtual ~TKinokoDevicePool();
    virtual void Destroy(void);
    virtual int RegisterCrate(const std::string& Name, TRoomCrate* Crate);
    virtual int RegisterController(const std::string& Name, TRoomController* Controller);
    virtual int RegisterModule(const std::string& ModuleName, TRoomModule* Module);
    virtual int RegisterRegister(const std::string& ResisterName, int* Register);
    virtual int RegisterDataRecord(const std::string& DataRecordName, TKinokoDataRecord* DataRecord);
    virtual TRoomModule* LookupModule(const std::string& ModuleName);
    virtual int* LookupRegister(const std::string& RegisterName);
    virtual int DeviceIdOf(const std::string& DeviceName);
    virtual std::string DeviceNameOf(int DeviceId);
    virtual int RegisterDeviceName(const std::string& DeviceName);
  public:
    virtual void ProbeDevices(void) throw(TKinokoException);
    virtual void Initialize(void) throw(TKinokoException);
    virtual void Finalize(void) throw(TKinokoException);
    virtual void Clear(void) throw(TKinokoException);
  protected:
    std::map<int, TRoomCrate*> _CrateTable;
    std::map<int, TRoomController*> _ControllerTable;
    std::map<int, TRoomModule*> _ModuleTable;
    std::map<int, int*> _RegisterTable;
    std::map<int, TKinokoDataRecord*> _DataRecordTable;
    std::map<std::string, int> _DeviceNameToIdTable;
    std::map<int, std::string> _DeviceIdToNameTable;
    int _NextDeviceId;
};

#endif
