/* KinokoScriptedDaqBuilder.cc */
/* Created by Enomoto Sanshiro on 9 October 1999. */
/* Last updated by Enomoto Sanshiro on 4 July 2001. */


#include <fstream>
#include <string>
#include "KinokoDaqBuilder.hh"
#include "KinokoScriptedDaqBuilder.hh"
#include "KinokoDaqScript.hh"

using namespace std;


TKinokoScriptedDaqBuilder::TKinokoScriptedDaqBuilder(const string& ScriptFileName, const string& DataSourceName, int DataSourceId, TKinokoOutputStream* OutputStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry, bool IsScriptTest)
: TKinokoDaqBuilder(DataSourceName, DataSourceId, OutputStream, EventEmitter, Registry)
{
    _ScriptFileName = ScriptFileName;
    _DataSourceName = DataSourceName;
    _DataSourceId = DataSourceId;
    _IsScriptTest = IsScriptTest;
}

TKinokoScriptedDaqBuilder::~TKinokoScriptedDaqBuilder()
{
}

void TKinokoScriptedDaqBuilder::Construct(void) throw(TKinokoException)
{
    ifstream ScriptFile(_ScriptFileName.c_str());
    if (! ScriptFile) {
	throw TKinokoException("unable to open file: " + _ScriptFileName);
    }

    TKinokoDaqScript* Script = 0;
    try {
	Script = new TKinokoDaqScript(this, _ScriptFileName, _IsScriptTest);
	Script->Parse(ScriptFile);

	if (_DataSourceNameList.empty()) {
	    throw TKinokoException(
		"script exception: no datasource entry defined"
	    );
	}

	if (_DataSourceName.empty()) {
	    _DataSourceName = _DataSourceNameList[0].first;
	}

	for (unsigned i = 0; i < _DataSourceNameList.size(); i++) {
	    if (_DataSourceName == _DataSourceNameList[i].first) {
		if (_DataSourceNameList[i].second > 0) {
		    _DataSourceId = _DataSourceNameList[i].second;
		}
		break;
	    }
	}

	_DataSource->SetName(_DataSourceName, _DataSourceId);

	Script->Execute(_DataSourceName);
    }
    catch (TScriptException &e) {
        throw TKinokoException("script exception: " + e.Message());
    }

    delete Script;
}

