/* dump-event.cc */
/* Edited by Enomoto Sanshiro on 4 September 2009. */
/* Last updated by Enomoto Sanshiro on 26 April 2010. */


#include <iostream>
#include "MushArgumentList.hh"
#include "KinokoEventProcessor.hh"
#include "KinokoEventDumper.hh"
#include "KinokoEventSegmentPacker.hh"
#include "KinokoStandaloneComponent.hh"

using namespace std;

int main(int argc, char** argv)
{
    if (argc < 3) {
	cerr << "Usage: " << argv[0] << " INPUT_FILE DATASOURCE_NAME" << endl;
	return -1;
    }
    TMushArgumentList ArgumentList(argc, argv);
    
    string InputDataSourceName = ArgumentList[1];

    TKinokoEventPieceDumper PieceDumper(cout);
    TKinokoEventSegmentUnpacker Unpacker(&PieceDumper);
    TKinokoEventConsumer EventConsumer(InputDataSourceName, &Unpacker);

    TKinokoStandaloneDataConsumer StandaloneConsumer(
	&EventConsumer, "EventDumper"
    );
    
    try {
	StandaloneConsumer.Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }
    
    return 0;
}
