/* kinoko-input-watcher-test.cc */
/* Created by Enomoto Sanshiro on 12 January 2004. */
/* Last updated by Enomoto Sanshiro on 12 January 2004. */


#include <iostream>
#include "MushTimer.hh"
#include "KinokoControlInputWatcher.hh"

using namespace std;


int main(void)
{
    TKinokoControlInputWatcher InputWatcher(cin);
    InputWatcher.Start();

    TMushSignalHandler SignalHandler;
    TMushSignalCounter SignalCounter;

    SignalHandler.RegisterClient(SIGTERM, &SignalCounter);
    SignalHandler.RegisterClient(SIGINT, &SignalCounter);
    SignalHandler.RegisterClient(SIGQUIT, &SignalCounter);
    SignalHandler.StartHandling();

    while (1) {
	if (InputWatcher.IsDataAvailable()) {
	    cout << "{" << InputWatcher.Line() << "}" << endl;
	    InputWatcher.Flush();
	}
	if (cin.eof()) {
	    break;
	}

	cout << '.' << flush;
	TMushRealTimeTimer(0, 100000).Suspend();

	if (SignalCounter.SignalCount() > 0) {
	    cout << '*' << flush;
	    SignalCounter.DecrimentCount();
	}
    }

    InputWatcher.Stop();
    cout << endl;

    return 0;
}
