/* kinoko-test-server.cc */
/* Created by Enomoto Sanshiro on 24 June 2009. */
/* Last updated by Enomoto Sanshiro on 24 June 2009. */


#include <iostream>
#include <string>
#include <algorithm>
#include "MushNetworkSocket.hh"
#include "MushSocketSelector.hh"
#include "MushSocketStream.hh"
#include "MushArgumentList.hh"
#include "MushTimer.hh"
#include "MushSignal.hh"

using namespace std;

int ProcessRequest(iostream& Stream);


int main(int argc, char **argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " PortNumber" << endl;
	return -1;
    }

    TMushArgumentList ArgumentList(argc, argv);
    int PortNumber;

    TMushServerNetworkSocket *Socket = 0;
    try {
	PortNumber = ArgumentList.IntParameterOf(0);
	cout << "listening at " << PortNumber << endl;

	Socket = new TMushServerNetworkSocket(PortNumber);
	Socket->EnableLocalAddressReuse();
	Socket->Open();

	cout << "connected. remote host is: " << Socket->RemoteHostName() << endl;
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
	return -1;
    }

    TMushSignalHandler SignalHandler;
    TMushSignalCounter SignalCounter;
    SignalHandler.RegisterClient(SIGINT, &SignalCounter);
    SignalHandler.RegisterClient(SIGTERM, &SignalCounter);
    SignalHandler.StartHandling();

    TMushSocketSelector SocketSelector;
    SocketSelector.AddSocket(Socket);

    TMushInputOutputSocketStream Stream(Socket);

    try {
	while (SignalCounter.SignalCount() == 0) {
	    TMushSocketSelector::TSocketEvent SocketEvent = (
		SocketSelector.WaitEvent(0).second
	    ); 
	    if (SocketEvent == TMushSocketSelector::SocketEvent_HungUp) {
		cout << "connection hung up" << endl;
		break;
	    }
	    else if (SocketEvent == TMushSocketSelector::SocketEvent_DataArrived) {
		ProcessRequest(Stream);
	    }
	}
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
    }

    cout << "shutting down..." << flush;
    Socket->Close();
    cout << "done." << endl;

    delete Socket;

    return 0;
}


int ProcessRequest(iostream& Stream)
{
    static bool IsTextMode = false;
    
    string Command;
    if (Stream >> Command) {
	cout << "input command: [" << Command << "] " << flush;
	if (Command == "READ") {
	    int Size;
	    if (Stream >> Size) {
		cout << Size << flush;
		static int DummyData = 0; DummyData++;
		if (IsTextMode) {
		    for (int i = 0; i < Size; i++) {
			Stream << i << " ";
		    }
		    Stream << endl;
		}
		else {
		    static char Buffer[65536];
		    Size = min(Size, (int) sizeof(Buffer)) / sizeof(int);
		    for (int i = 0; i < Size; i++) {
			((int*) Buffer)[i] = DummyData;
		    }
		    Stream.write(Buffer, Size * sizeof(int));
		}
	    }
	    Stream << flush;
	}
	else if (Command == "TEXT") {
	    IsTextMode = true;
	}
	else if (Command == "WAIT") {
	    int Time;
	    if (Stream >> Time) {
		cout << Time << flush;
		TMushRealTimeTimer(Time, 0).Suspend();
	    }
	}
	else if (Command == "QUIT") {
	    TMushSignalSender::Raise(SIGTERM);
	}
	cout << endl;
    }

    return 1;
}
