/* KinokoKdfStorage.hh */
/* Created by Enomoto Sanshiro on 9 January 2000. */
/* Last updated by Enomoto Sanshiro on 6 October 2002. */


#ifndef __KinokoKdfStorage_hh__
#define __KinokoKdfStorage_hh__


#include <string>
#include "MushFramedFile.hh"
#include "MushDataEncoder.hh"
#include "KinokoFileStream.hh"
#include "KinokoStorage.hh"


class TKinokoKdfStorage: public TKinokoStorage {
  public:
    TKinokoKdfStorage(const std::string& FileName, bool IsRawStorage = false);
    virtual ~TKinokoKdfStorage();
    virtual int WriteHeader(const TKinokoStorageHeader& Header) throw(TKinokoException);
    virtual int ReadHeader(TKinokoStorageHeader& Header) throw(TKinokoException);
    virtual TKinokoOutputFileStream* GetOutputStream(void) throw (TKinokoException);
    virtual TKinokoInputFileStream* GetInputStream(void) throw (TKinokoException);
    virtual long DataFilePreambleVersion(void) const;
    virtual long DataFileHeaderVersion(void) const;
    virtual long DataFileDataAreaVersion(void) const;
    virtual long DataFileFormatFlags(void) const;
    virtual void SetMaxSubfileSize(long MaxSubfileSize);
    static int VersionNumberOf(int MajorVersion, int MinorVersion);
  public:
    // for debugging //
    TMushFramedFile* InputFile(void) { return _InputFile; }
    TMushFramedFile* OutputFile(void) { return _OutputFile; }
    TMushFile* InputRawFile(void) { return _InputRawFile; }
    TMushFile* OutputRawFile(void) { return _OutputRawFile; }
  protected:
    virtual void OpenInputRawFile(void) throw(TKinokoException);
    virtual void OpenOutputRawFile(void) throw(TKinokoException);
    virtual int WritePreamble(void) throw(TKinokoException);
    virtual int ReadPreamble(void) throw(TKinokoException);
  protected:
    std::string _FileName;
    TMushFile* _InputRawFile;
    TMushFile* _OutputRawFile;
    TMushFramedFile* _InputFile;
    TMushFramedFile* _OutputFile;
    TKinokoInputFileStream* _InputStream;
    TKinokoOutputFileStream* _OutputStream;
    char* _HeaderString;
    long _PreambleVersion;
    long _HeaderVersion;
    long _HeaderAreaOffset;
    long _HeaderAreaSize;
    long _DataAreaVersion;
    long _DataAreaOffset;
    long _DataAreaFormatFlags;
    bool _IsRawStorage;
    long _MaxSubfileSize;
  public:
    enum TDataAreaFormatFlags {
	FormatFlag_DataCompressionEnabled = 0x0001,
	FormatFlag_IndexEnabled = 0x0002,
	_NumberOfFormatFlags
    };
};


#endif
