/* KinokoStorage.cc */
/* Created by Enomoto Sanshiro on 9 January 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2000. */


#include "KinokoStorage.hh"

using namespace std;


TKinokoStorage::TKinokoStorage(void)
{
    _IsOverWriteAllowed = false;
    _OutputFileAccessMode = 0644;

    _IsDataCompressionEnabled = false;
    _IsIndexEnabled = false;
}

TKinokoStorage::~TKinokoStorage()
{
}

void TKinokoStorage::AllowOverWrite(void)
{
    _IsOverWriteAllowed = true;
}

void TKinokoStorage::SetAccessMode(int AccessMode)
{
    _OutputFileAccessMode = AccessMode;
}

void TKinokoStorage::EnableDataCompression(void)
{
    _IsDataCompressionEnabled = true;
}

bool TKinokoStorage::IsDataCompressionEnabled(void)
{
    return _IsDataCompressionEnabled;
}

void TKinokoStorage::EnableIndex(void)
{
    _IsIndexEnabled = true;
}

bool TKinokoStorage::IsIndexEnabled(void)
{
    return _IsIndexEnabled;
}

int TKinokoStorage::WritePreamble(void) throw(TKinokoException)
{
    return 0;
}

int TKinokoStorage::ReadPreamble(void) throw(TKinokoException)
{
    return 0;
}
