/* KinokoStorage.hh */
/* Created by Enomoto Sanshiro on 9 January 2000. */
/* Last updated by Enomoto Sanshiro on 20 January 2000. */


#ifndef __KinokoStorage_hh__
#define __KinokoStorage_hh__


#include "KinokoFileStream.hh"
#include "KinokoStorageHeader.hh"


class TKinokoStorage {
  public:
    TKinokoStorage(void);
    virtual ~TKinokoStorage();
    virtual void AllowOverWrite(void);
    virtual void SetAccessMode(int AccessMode);
    virtual void EnableDataCompression(void);
    virtual bool IsDataCompressionEnabled(void);
    virtual void EnableIndex(void);
    virtual bool IsIndexEnabled(void);
    virtual int WritePreamble(void) throw(TKinokoException);
    virtual int ReadPreamble(void) throw(TKinokoException);
    virtual int WriteHeader(const TKinokoStorageHeader& Header) throw(TKinokoException) = 0;
    virtual int ReadHeader(TKinokoStorageHeader& Header) throw(TKinokoException) = 0;
    virtual TKinokoOutputFileStream* GetOutputStream(void) throw (TKinokoException) = 0;
    virtual TKinokoInputFileStream* GetInputStream(void) throw (TKinokoException) = 0;
  protected:
    bool _IsOverWriteAllowed;
    int _OutputFileAccessMode;
    bool _IsDataCompressionEnabled;
    bool _IsIndexEnabled;
};


#endif
