/* KinokoSocketStream.hh */
/* Created by Enomoto Sanshiro on 23 February 1998. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#ifndef __KinokoSocketStream_hh__
#define __KinokoSocketStream_hh__


#include "MushDecoratedSocket.hh"
#include "MushSocketSelector.hh"
#include "KinokoStream.hh"


class TKinokoInputSocketStream: public TKinokoInputStream {
  public:
    TKinokoInputSocketStream(TMushFramedSocket *Socket, int LocalBufferSize = 1024*1024, int LocalBufferEntryTableSize = 4096) throw(TKinokoException);
    virtual ~TKinokoInputSocketStream();
    virtual void Destroy(void);
    virtual bool HasData(void);
    virtual size_t NextDataSize(void);
    virtual int Read(void *Address, size_t MaxSize) throw(TKinokoException);
    virtual int NextEntry(void *&Address) throw(TKinokoException);
    virtual void Flush(void* Address) throw(TKinokoException);
    virtual int GetEntry(void *&Address) throw(TKinokoException);
    virtual void ReleaseEntry(void* Address) throw(TKinokoException);
  protected:
    TMushSocketSelector* _SocketSelector;
    TMushFramedSocket *_Socket;
};


class TKinokoOutputSocketStream: public TKinokoOutputStream {
  public:
    TKinokoOutputSocketStream(TMushFramedSocket *Socket, int LocalBufferSize = 1024*1024, int LocalBufferEntryTableSize = 4096) throw(TKinokoException);
    virtual ~TKinokoOutputSocketStream();
    virtual void Destroy(void);
    virtual int Write(void *Address, size_t Size) throw(TKinokoException);
    virtual int NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int Flush(void* Address, size_t Size) throw(TKinokoException);
    virtual int GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int ReleaseEntry(void* Address, size_t Size) throw(TKinokoException);
  protected:
    TMushFramedSocket *_Socket;
};


#endif
