/* KinokoHistogramView.hh */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 4 November 2000. */


#ifndef __KinokoHistogramView_hh__
#define __KinokoHistogramView_hh__


#include <iostream>
#include <string>
#include "KameHistogram.hh"
#include "KameRepository.hh"
#include "KinokoView.hh"

class TKinokoConfidenceBand;


class TKinokoHistogramView: public TKinokoView {
  public:
    TKinokoHistogramView(kame::TKameHistogram* Histogram);
    virtual ~TKinokoHistogramView();
    virtual void SetDisplayStatistics(int StatisticsFlags);
    virtual void SetYScaleLog(void);
    virtual void SetYScaleLinear(void);
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
    virtual void SetReferenceHistogram(kame::TKameHistogram* ReferenceHistogram, double ToleranceSigmas);
  protected:
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    kame::TKameHistogram* _Histogram;
    float _Min, _Max, _NumberOfBins, _BinStep;
    float _YMin, _YMax;
    bool _IsYScaleLog;
    std::string _XTitle, _YTitle;
    kame::TKameHistogram* _ReferenceHistogram;
    TKinokoConfidenceBand* _ConfidenceBand;
    int _DisplayStatisticsFlags;
  public:
    enum TDisplayStatisticsFlag {
	Stat_Entries = 0x0001 << 0,
	Stat_Underflow = 0x0001 << 1,
	Stat_Overflow = 0x0001 << 2,
	Stat_Mean = 0x0001 << 3,
	Stat_Sum = 0x0001 << 4,
	Stat_Deviation = 0x0001 << 5,
	_NumberOfStats
    };
};



class TKinokoKoapHistogramView: public TKinokoHistogramView {
  public:
    TKinokoKoapHistogramView(kame::TKameHistogram* Histogram, std::ostream* OutputStream);
    virtual ~TKinokoKoapHistogramView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};



class TKinokoConfidenceBand {
  public:
    TKinokoConfidenceBand(double NSigmas);
    virtual ~TKinokoConfidenceBand();
    virtual void GetBand(double Mean, double& Lower, double& Upper);
  protected:
    double _NSigmas, _HalfCoverage;
    std::vector<std::pair<double, std::pair<double, double> > > _PoissonIntervalTable;
};



#endif
