/* KinokoSchematicView.cc */
/* Created by Enomoto Sanshiro on 5 October 2008. */
/* Last updated by Enomoto Sanshiro on 5 October 2008. */


#include <iostream>
#include <sstream>
#include <string>
#include <cmath>
#include <vector>
#include <map>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoSchematicView.hh"

using namespace std;
using namespace kame;


TKinokoSchematicView::TKinokoSchematicView(TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax)
{
    _Ntuple = Ntuple;

    _XMin = XMin; _XMax = XMax;
    _YMin = YMin; _YMax = YMax;
}

TKinokoSchematicView::~TKinokoSchematicView()
{
    delete _Ntuple;
}

void TKinokoSchematicView::SaveThis(TKameRepository* Repository)throw(TKinokoException)
{
    try {
	Repository->SaveNtuple(*_Ntuple, _Name);
    }
    catch (TKameException &e) {
	throw TKinokoException(
	    "TKinokoSchematicView::SaveThis()", e.Message()
	);
    }
}

void TKinokoSchematicView::ClearThis(void)
{
    _Ntuple->Clear();
}




TKinokoKoapSchematicView::TKinokoKoapSchematicView(TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax, ostream* OutputStream)
: TKinokoSchematicView(Ntuple, XMin, XMax, YMin, YMax)
{
    _OutputStream = OutputStream;

    _CurrentColorScaleId = -1;
}

TKinokoKoapSchematicView::~TKinokoKoapSchematicView()
{
}

int TKinokoKoapSchematicView::SetColorScale(float Min, float Max, const std::string& Type)
{
    int ScaleId = _ScaleDeclarationList.size() + 1;

    ostringstream os;
    os << "createscale scale_" << ScaleId << " ";
    os << Min << " " << Max << " " << Type;

    _ScaleDeclarationList.push_back(os.str());
    _CurrentColorScaleId = ScaleId;

    return ScaleId;
}

int TKinokoKoapSchematicView::PutTextItem(int Address, float X0, float Y0, const std::string& Format)
{
    int ItemId = _ItemDeclarationList.size();

    ostringstream os;
    os << "createitem " << ItemId << " text ";
    os << X0 << " " << Y0 << " " << Format;

    _ItemDeclarationList.push_back(os.str());
    _ItemIdTable.insert(make_pair(Address, ItemId));

    return ItemId;
}

int TKinokoKoapSchematicView::PutRectangleItem(int Address, float X0, float Y0, float X1, float Y1)
{
    int ItemId = _ItemDeclarationList.size();

    ostringstream os;
    os << "createitem " << ItemId << " rectangle ";
    os << X0 << " " << Y0 << " " << X1 << " " << Y1 << " ";

    if (_CurrentColorScaleId > 0) {
	os << "scale_" << _CurrentColorScaleId;
    }

    _ItemDeclarationList.push_back(os.str());
    _ItemIdTable.insert(make_pair(Address, ItemId));

    return ItemId;
}

int TKinokoKoapSchematicView::PutCircleItem(int Address, float X0, float Y0, float Radius)
{
    int ItemId = _ItemDeclarationList.size();

    ostringstream os;
    os << "createitem " << ItemId << " circle ";
    os << X0 << " " << Y0 << " " << Radius << " ";

    if (_CurrentColorScaleId > 0) {
	os << "scale_" << _CurrentColorScaleId;
    }

    _ItemDeclarationList.push_back(os.str());
    _ItemIdTable.insert(make_pair(Address, ItemId));

    return ItemId;
}

void TKinokoKoapSchematicView::DeployThis(void) 
{
    *_OutputStream << ".selectPage " << _PageNumber << ";" << endl;

    *_OutputStream << ".create schematic " << _Name << " ";
    *_OutputStream << 100 * Left() << " " << 100 * Top() << " ";
    *_OutputStream << 100 * Width() << " " << 100 * Height() << ";" << endl;

    *_OutputStream << _Name << " set title " << _Ntuple->Title() << ";" << endl;
    *_OutputStream << _Name << " set foreground white;" << endl;
    *_OutputStream << _Name << " set background black;" << endl;

    *_OutputStream << _Name << " frame ";
    *_OutputStream << _XMin << " " << _XMax << " ";
    *_OutputStream << _YMin << " " << _YMax << ";" << endl;

    for (unsigned i = 0; i < _ScaleDeclarationList.size(); i++) {
	*_OutputStream << _Name << " " << _ScaleDeclarationList[i];
	*_OutputStream << ";" << endl;
    }

    for (unsigned i = 0; i < _ItemDeclarationList.size(); i++) {
	*_OutputStream << _Name << " " << _ItemDeclarationList[i];
	*_OutputStream << ";" << endl;
    }
}

void TKinokoKoapSchematicView::DrawThis(void)
{
    *_OutputStream << _Name << " clear;" << endl;
    *_OutputStream << _Name << " drawframe;" << endl;

    if (_Ntuple->NumberOfRows() == 0) {
	return;
    }

    *_OutputStream << _Name << " setvalue ";
    int Address, ItemId;
    int NumberOfPoints = _Ntuple->NumberOfRows();
    for (int Index = 0; Index < NumberOfPoints; Index++) {
	Address = (*_Ntuple)[Index][0];
	typedef multimap<int, int>::const_iterator Iterator;
	pair<Iterator, Iterator> Range = _ItemIdTable.equal_range(Address);
	for (Iterator i = Range.first; i != Range.second; i++) {
	    ItemId = i->second;
	    *_OutputStream << " " << ItemId << " " << (*_Ntuple)[Index][1];
	}
    }
    *_OutputStream << ";" << endl;
}

void TKinokoKoapSchematicView::ClearThis(void)
{
    TKinokoSchematicView::ClearThis();

    *_OutputStream << _Name << " clear;" << endl;
    *_OutputStream << _Name << " drawframe;" << endl;
}
