/* KinokoHistogramView.cc */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 25 January 2001. */


#include <cmath>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoTabularView.hh"

using namespace std;
using namespace kame;


TKinokoTabularView::TKinokoTabularView(TKameNtuple* Ntuple, int NumberOfColumns)
{
    _Ntuple = Ntuple;
    _NumberOfColumns = NumberOfColumns;
}

TKinokoTabularView::~TKinokoTabularView()
{
    delete _Ntuple;
}

void TKinokoTabularView::SaveThis(TKameRepository* Repository)throw(TKinokoException)
{
    try {
	Repository->SaveNtuple(*_Ntuple, _Name);
    }
    catch (TKameException &e) {
	throw TKinokoException(
	    "TKinokoTabularView::SaveThis()", e.Message()
	);
    }
}

void TKinokoTabularView::ClearThis(void)
{
    _Ntuple->Clear();
}




TKinokoKoapTabularView::TKinokoKoapTabularView(TKameNtuple* Ntuple, int NumberOfColumns, ostream* OutputStream)
: TKinokoTabularView(Ntuple, NumberOfColumns)
{
    _OutputStream = OutputStream;
}

TKinokoKoapTabularView::~TKinokoKoapTabularView()
{
}

void TKinokoKoapTabularView::DeployThis(void) 
{
    *_OutputStream << ".selectPage " << _PageNumber << ";" << endl;

    (*_OutputStream) << ".create textbox " << _Name << " ";
    (*_OutputStream) << 100 * Left() << " " << 100 * Top() << " ";
    (*_OutputStream) << 100 * Width() << " " << 100 * Height() << ";" << endl;

    (*_OutputStream) << _Name << " set title " << _Ntuple->Title() << ";" << endl;
    (*_OutputStream) << _Name << " set columns " << _NumberOfColumns << ";" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;
}

void TKinokoKoapTabularView::DrawThis(void)
{
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;

    if (_Ntuple->NumberOfRows() == 0) {
        (*_OutputStream) << _Name << " write ";
        (*_OutputStream) << "no data;" << endl;
	return;
    }

    int NumberOfFields = _Ntuple->NumberOfColumns();

    (*_OutputStream) << _Name << " write " << endl;
    for (int i = 0; i < NumberOfFields; i++) {
	(*_OutputStream) << (*_Ntuple)[i][0] << ": ";
	(*_OutputStream) << (*_Ntuple)[i][1] << endl;
    }
    (*_OutputStream) << ";" << endl;
}

void TKinokoKoapTabularView::ClearThis(void)
{
    TKinokoTabularView::ClearThis();
    
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;
}
