/* KinokoTabularView.hh */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 25 January 2001. */


#ifndef __KinokoTabularView_hh__
#define __KinokoTabularView_hh__


#include <iostream>
#include <string>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoView.hh"


class TKinokoTabularView: public TKinokoView {
  public:
    TKinokoTabularView(kame::TKameNtuple* Ntuple, int NumberOfColumns);
    virtual ~TKinokoTabularView();
  protected:
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    kame::TKameNtuple* _Ntuple;
    int _NumberOfColumns;
};



class TKinokoKoapTabularView: public TKinokoTabularView {
  public:
    TKinokoKoapTabularView(kame::TKameNtuple* Ntuple, int NumberOfColumns, std::ostream* OutputStream);
    virtual ~TKinokoKoapTabularView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
