/* KinokoTrendView.hh */
/* Created by Enomoto Sanshiro on 5 December 2000. */
/* Updated by Enomoto Sanshiro on 29 September 2002. */
/* Last updated by Enomoto Sanshiro on 13 February 2008. */


#ifndef __KinokoTrendView_hh__
#define __KinokoTrendView_hh__


#include <string>
#include <iostream>
#include "KameTrend.hh"
#include "KameRepository.hh"
#include "KinokoPlatform.hh"
#include "KinokoView.hh"


class TKinokoTrendView: public TKinokoView {
  public:
    TKinokoTrendView(kame::TKameTrend* Trend, double MinValue, double MaxValue);
    virtual ~TKinokoTrendView();
    virtual void Draw(void);
    virtual void SetDisplayValue(int FieldId);
    virtual void SetDisplayStatistics(int StatisticsFlags);
    virtual void SetYScaleLog(void);
    virtual void SetYScaleLinear(void);
    virtual void SetTimeTick(const std::string& Format, const std::string& Unit, int Step);
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
    virtual void SetOperationRange(double LowerBound, double UpperBound, int NumberOfPointsToJudge);
    virtual void EnableAlarm(TKinokoEventEmitter* EventEmitter, const std::string& Message);
    virtual void DisableAlarm(void);
  protected:
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    virtual void CheckValueRange(double Value);
    virtual void InitializeTimeTick(int Epoch);
  protected:
    kame::TKameTrend* _Trend;
    int _DisplayValueFieldId;
    double _MinValue, _MaxValue, _WindowLength;
    long _DataStartTime, _DisplayStartTime;
    double _LowerBound, _UpperBound;
    unsigned long _NumberOfPointsToJudge;
    unsigned long _NumberOfPointsInside, _NumberOfPointsOutside;
    std::string _XTitle, _YTitle;
    TKinokoEventEmitter* _EventEmitter;
    std::string _AlarmMessage;
    bool _IsYScaleLog;
    int _DisplayStatisticsFlags;
    bool _IsDisplayStatisticsSpecified;
    std::string _TimeTickFormat, _TimeTickUnit;
    int _TimeTickStep;
    bool _IsTimeTickInitialized, _IsTimeTickAbsolute;
  public:
    enum TFieldId {
        FieldId_Counts,
	FieldId_Sum,
	FieldId_Mean,
	FieldId_Deviation,
	_NumberOfFieldIds
    };
    enum TDisplayStatisticsFlag {
	Stat_Counts = 0x0001 << 0,
	Stat_Mean = 0x0001 << 1,
	Stat_Sum = 0x0001 << 2,
	Stat_Deviation = 0x0001 << 3,
	_NumberOfStats
    };
};



class TKinokoKoapTrendView: public TKinokoTrendView {
  public:
    TKinokoKoapTrendView(kame::TKameTrend* Trend, double MinValue, double MaxValue, std::ostream* OutputStream);
    virtual ~TKinokoKoapTrendView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    virtual void DrawCountPlot(void);
    virtual void DrawSumPlot(void);
    virtual void DrawMeanPlot(bool DrawsDeviation);
    virtual void InitializeTimeTick(int Epoch);
  protected:
    std::ostream* _OutputStream;
};


#endif
