/* KinokoView.hh */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 15 June 2002. */


#ifndef __KinokoView_hh__
#define __KinokoView_hh__


#include <string>
#include <vector>
#include "KinokoDefs.hh"
#include "KinokoViewTrimming.hh"
#include "KameRepository.hh"


class TKinokoView {
  public:
    TKinokoView(void);
    virtual ~TKinokoView();
    virtual void SetName(const std::string& Name);
    virtual void SetParent(TKinokoView* ParentView);
    virtual void SetPosition(float Left, float Top, float Width, float Height);
    virtual void SetPage(int PageNumber);
    virtual const std::string& Name(void) const;
    virtual TKinokoView* Parent(void);
    virtual float Left(void) const;
    virtual float Top(void) const;
    virtual float Width(void) const;
    virtual float Height(void) const;
    virtual void AddViewTrimming(TKinokoViewTrimming* Trimming);
    virtual bool SetDrawOption(const std::string& OptionString);
  public:
    virtual void Deploy(void);
    virtual void Draw(void);
    virtual void Clear(void);
    virtual void Save(kame::TKameRepository* Repository) throw(TKinokoException);
  protected:
    virtual void DeployThis(void) = 0;
    virtual void DrawThis(void) = 0;
    virtual void ClearThis(void) = 0;
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException) = 0;
  protected:
    TKinokoView* _ParentView;
    std::string _Name;
    float _Left, _Top;
    float _Width, _Height;
    int _PageNumber;
    std::vector<TKinokoViewTrimming*> _TrimmingList;
  private:
    static int _ViewCount;
};

#endif
