/* KinokoViewCanvas.cc */
/* Created by Enomoto Sanshiro on 2 January 2001. */
/* Last updated by Enomoto Sanshiro on 1 September 2008. */


#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <cmath>
#include "MushFileSystem.hh"
#include "KinokoViewCanvas.hh"

using namespace std;


TKinokoViewCanvas::TKinokoViewCanvas(void)
{
}

TKinokoViewCanvas::~TKinokoViewCanvas()
{
}

void TKinokoViewCanvas::DestroyViews(void)
{
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	delete _ViewList[i];
    }

    for (unsigned i = 0; i < _PageList.size(); i++) {
	delete _PageList[i];
    }
}

void TKinokoViewCanvas::AddView(TKinokoView* View)
{
    _ViewList.push_back(View);
}

void TKinokoViewCanvas::AddPage(TKinokoViewCanvasPage* Page)
{
    _PageList.push_back(Page);
}

int TKinokoViewCanvas::NumberOfPages(void)
{
    return _PageList.size();
}

void TKinokoViewCanvas::DrawAll(void)
{
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	_ViewList[i]->Draw();
    }
}



TKinokoKoapViewCanvas::TKinokoKoapViewCanvas(std::ostream* OutputStream)
{
    _OutputStream = OutputStream;
}

TKinokoKoapViewCanvas::~TKinokoKoapViewCanvas()
{
}

void TKinokoKoapViewCanvas::DeployViews(void)
{
    *_OutputStream << ".reset;" << endl;

    TKinokoViewCanvasPage* DefaultPage = 0;
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	if (_ViewList[i]->Parent() == 0) {
	    if (DefaultPage == 0) {
		DefaultPage = new TKinokoKoapViewCanvasPage(
		    NumberOfPages(), "", _OutputStream
		);
		AddPage(DefaultPage);
	    }
	    DefaultPage->AddView(_ViewList[i]);
	}
    }

    for (unsigned i = 0; i < _PageList.size(); i++) {
	_PageList[i]->DeployViews();
    }
}

void TKinokoKoapViewCanvas::Update(void)
{
    *_OutputStream << ".redraw;" << endl;
}

void TKinokoKoapViewCanvas::Clear(void)
{
    *_OutputStream << ".clear;" << endl;
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	_ViewList[i]->Clear();
    }
    *_OutputStream << ".redraw;" << endl;
}

int TKinokoKoapViewCanvas::SaveImage(const std::string& ImageFileName)
{
    int NumberOfPages = _PageList.size();
    if (NumberOfPages <= 0) {
	;
    }
    else if (NumberOfPages == 1) {
	*_OutputStream << ".saveImage " << ImageFileName << ";" << endl;
    }
    else {
	string Path = TMushFileAttribute(ImageFileName).PathName();
	string Name = TMushFileAttribute(ImageFileName).FileRootName();
	string Extension = TMushFileAttribute(ImageFileName).Extension();
	if (! Path.empty()) {
	    Name = Path + "/" + Name;
	}

	for (int Page = 0; Page < NumberOfPages; Page++) {
	    *_OutputStream << ".selectPage " << Page << ";" << endl;
	    *_OutputStream << ".saveImage " << Name << "-" << Page;
	    *_OutputStream << "." << Extension << ";" << endl;
	}
    }

    return NumberOfPages;
}
