/* KinokoViewCanvasPage.hh */
/* Created by Enomoto Sanshiro on 1 September 2008. */
/* Last updated by Enomoto Sanshiro on 1 September 2008. */


#ifndef __KinokoViewCanvasPage_hh__
#define __KinokoViewCanvasPage_hh__


#include <string>
#include <iostream>
#include "KinokoViewFrame.hh"


class TKinokoViewCanvasPage {
  public:
    TKinokoViewCanvasPage(int PageNumber, const std::string& PageName);
    virtual ~TKinokoViewCanvasPage();
    virtual void AddView(TKinokoView* View);
    virtual void DeployViews(void);
  protected:
    int _PageNumber;
    std::string _PageName;
    TKinokoViewFrame* _RootFrame;
};


class TKinokoKoapViewCanvasPage: public TKinokoViewCanvasPage {
  public:
    TKinokoKoapViewCanvasPage(int PageNumber, const std::string& PageName, std::ostream* OutputStream);
    virtual ~TKinokoKoapViewCanvasPage();
    virtual void DeployViews(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
