/* KinokoViewFactory.cc */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#include <iostream>
#include "KinokoViewCanvas.hh"
#include "KinokoHistogramView.hh"
#include "KinokoHistogram2dView.hh"
#include "KinokoTrendView.hh"
#include "KinokoHistoryView.hh"
#include "KinokoWaveView.hh"
#include "KinokoMapView.hh"
#include "KinokoTabularView.hh"
#include "KinokoPictureView.hh"
#include "KinokoSchematicView.hh"
#include "KinokoViewFactory.hh"

using namespace std;
using namespace kame;


TKinokoViewFactory::TKinokoViewFactory(void)
{
}

TKinokoViewFactory::~TKinokoViewFactory()
{
}



TKinokoKoapViewFactory::TKinokoKoapViewFactory(ostream* OutputStream)
{
    _OutputStream = OutputStream;
}

TKinokoKoapViewFactory::~TKinokoKoapViewFactory()
{
}

TKinokoViewCanvas* TKinokoKoapViewFactory::CreateViewCanvas(void)
{
    return new TKinokoKoapViewCanvas(_OutputStream);
}

TKinokoViewCanvasPage* TKinokoKoapViewFactory::CreateViewCanvasPage(int PageNumber, const std::string& PageName)
{
    return new TKinokoKoapViewCanvasPage(PageNumber, PageName, _OutputStream);
}

TKinokoHistogramView* TKinokoKoapViewFactory::CreateHistogramView(TKameHistogram* Histogram)
{
    return new TKinokoKoapHistogramView(Histogram, _OutputStream);
}

TKinokoHistogram2dView* TKinokoKoapViewFactory::CreateHistogram2dView(TKameHistogram2d* Histogram)
{
    return new TKinokoKoapHistogram2dView(Histogram, _OutputStream);
}

TKinokoTrendView* TKinokoKoapViewFactory::CreateTrendView(TKameTrend* Trend, double MaxValue, double MinValue)
{
    return new TKinokoKoapTrendView(Trend, MaxValue, MinValue, _OutputStream);
}

TKinokoHistoryView* TKinokoKoapViewFactory::CreateHistoryView(TKameHistory* History, double MaxValue, double MinValue, double WindowWidth)
{
    return new TKinokoKoapHistoryView(History, MaxValue, MinValue, WindowWidth, _OutputStream);
}

TKinokoWaveView* TKinokoKoapViewFactory::CreateWaveView(TKameNtuple* Ntuple, double XMin, double XMax, double YMin, double YMax)
{
    return new TKinokoKoapWaveView(Ntuple, XMin, XMax, YMin, YMax, _OutputStream);
}

TKinokoMapView* TKinokoKoapViewFactory::CreateMapView(TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax)
{
    return new TKinokoKoapMapView(Ntuple, XMin, XMax, YMin, YMax, ZMin, ZMax, _OutputStream);
}

TKinokoTabularView* TKinokoKoapViewFactory::CreateTabularView(TKameNtuple* Ntuple, int NumberOfColumns)
{
    return new TKinokoKoapTabularView(Ntuple, NumberOfColumns, _OutputStream);
}

TKinokoPictureView* TKinokoKoapViewFactory::CreatePictureView(const string& Title, float XMin, float XMax, float YMin, float YMax)
{
    return new TKinokoKoapPictureView(Title, XMin, XMax, YMin, YMax, _OutputStream);
}
    
TKinokoSchematicView* TKinokoKoapViewFactory::CreateSchematicView(TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax)
{
    return new TKinokoKoapSchematicView(Ntuple, XMin, XMax, YMin, YMax, _OutputStream);
}
    
TKinokoViewLineTrimming* TKinokoKoapViewFactory::CreateLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
{
    return new TKinokoViewKoapLineTrimming(View, x0, y0, x1, y1, _OutputStream);
}

TKinokoViewRectangleTrimming* TKinokoKoapViewFactory::CreateRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
{
    return new TKinokoViewKoapRectangleTrimming(View, x0, y0, x1, y1, _OutputStream);
}

TKinokoViewCircleTrimming* TKinokoKoapViewFactory::CreateCircleTrimming(TKinokoView* View, double x, double y, double r)
{
    return new TKinokoViewKoapCircleTrimming(View, x, y, r, _OutputStream);
}

TKinokoViewTextTrimming* TKinokoKoapViewFactory::CreateTextTrimming(TKinokoView* View, double x, double y, std::string Text)
{
    return new TKinokoViewKoapTextTrimming(View, x, y, Text, _OutputStream);
}

TKinokoViewImageTrimming* TKinokoKoapViewFactory::CreateImageTrimming(TKinokoView* View, double x, double y, std::string FileName)
{
    return new TKinokoViewKoapImageTrimming(View, x, y, FileName, _OutputStream);
}

TKinokoViewColorTrimming* TKinokoKoapViewFactory::CreateColorTrimming(TKinokoView* View, const string& ColorName)
{
    return new TKinokoViewKoapColorTrimming(View, ColorName, _OutputStream);
}

TKinokoViewTextAdjustmentTrimming* TKinokoKoapViewFactory::CreateTextAdjustmentTrimming(TKinokoView* View, const string& TextAdjustmentString)
{
    return new TKinokoViewKoapTextAdjustmentTrimming(View, TextAdjustmentString, _OutputStream);
}

TKinokoViewFontTrimming* TKinokoKoapViewFactory::CreateFontTrimming(TKinokoView* View, const string& FontName, int FontSize)
{
    return new TKinokoViewKoapFontTrimming(View, FontName, FontSize, _OutputStream);
}
