/* KinokoViewScript.hh */
/* Created by Enomoto Sanshiro on 26 December 2000. */
/* Last updated by Enomoto Sanshiro on 20 September 2001. */


#ifndef __KinokoViewScript_hh__
#define __KinokoViewScript_hh__


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KinokoAnalysisSequenceBuilder.hh"
#include "KinokoViewBuilder.hh"


class TKinokoViewScript: public TKiscScript {
  public:
    TKinokoViewScript(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder, const std::string& ScriptFileName);
    virtual ~TKinokoViewScript();
    virtual std::vector<std::string> DisplayNameList(void);
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoViewBuilder* _ViewBuilder;
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    std::string _ScriptFileName;
};


class TKinokoViewScriptDisplayEntry: public TParaPackageEntry {
  public:
    TKinokoViewScriptDisplayEntry(void);
    virtual ~TKinokoViewScriptDisplayEntry();
    virtual TParaPackageEntry* Clone(void);
    virtual bool HasEntryWordsOf(TParaTokenizer* Tokenizer);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue Execute(const std::vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaStatement* _Statement;
};


#endif
