/* KinokoViewTrimming.hh */
/* Created by Enomoto Sanshiro on 30 June 2002. */
/* Last updated by Enomoto Sanshiro on 30 June 2002. */


#ifndef __KinokoViewTrimming_hh__
#define __KinokoViewTrimming_hh__


#include <string>
#include <iostream>


class TKinokoView;


class TKinokoViewTrimming {
  public:
    TKinokoViewTrimming(TKinokoView* View);
    virtual ~TKinokoViewTrimming();
    virtual void Draw(void) = 0;
  protected:
    TKinokoView* _View;
};


class TKinokoViewLineTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1);
    virtual ~TKinokoViewLineTrimming();
  protected:
    double _x0, _y0, _x1, _y1;
};


class TKinokoViewRectangleTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1);
    virtual ~TKinokoViewRectangleTrimming();
  protected:
    double _x0, _y0, _x1, _y1;
};


class TKinokoViewCircleTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewCircleTrimming(TKinokoView* View, double x, double y, double r);
    virtual ~TKinokoViewCircleTrimming();
  protected:
    double _x, _y, _r;
};


class TKinokoViewTextTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewTextTrimming(TKinokoView* View, double x, double y, const std::string& Text);
    virtual ~TKinokoViewTextTrimming();
  protected:
    double _x, _y;
    std::string _Text;
};


class TKinokoViewImageTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewImageTrimming(TKinokoView* View, double x, double y, const std::string& FileName);
    virtual ~TKinokoViewImageTrimming();
  protected:
    double _x, _y;
    std::string _FileName;
};


class TKinokoViewColorTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewColorTrimming(TKinokoView* View, const std::string& ColorName);
    virtual ~TKinokoViewColorTrimming();
  protected:
    std::string _ColorName;
};


class TKinokoViewTextAdjustmentTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewTextAdjustmentTrimming(TKinokoView* View, const std::string& TextAdjustmentString);
    virtual ~TKinokoViewTextAdjustmentTrimming();
  protected:
    std::string _TextAdjustmentString;
};


class TKinokoViewFontTrimming: public TKinokoViewTrimming {
  public:
    TKinokoViewFontTrimming(TKinokoView* View, const std::string& FontName, int FontSize);
    virtual ~TKinokoViewFontTrimming();
  protected:
    std::string _FontName;
    int _FontSize;
};


class TKinokoViewKoapLineTrimming: public TKinokoViewLineTrimming {
  public:
    TKinokoViewKoapLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapLineTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapRectangleTrimming: public TKinokoViewRectangleTrimming {
  public:
    TKinokoViewKoapRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapRectangleTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapCircleTrimming: public TKinokoViewCircleTrimming {
  public:
    TKinokoViewKoapCircleTrimming(TKinokoView* View, double x, double y, double r, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapCircleTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapTextTrimming: public TKinokoViewTextTrimming {
  public:
    TKinokoViewKoapTextTrimming(TKinokoView* View, double x, double y, const std::string& Text, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapTextTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapImageTrimming: public TKinokoViewImageTrimming {
  public:
    TKinokoViewKoapImageTrimming(TKinokoView* View, double x, double y, const std::string& FileName, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapImageTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapColorTrimming: public TKinokoViewColorTrimming {
  public:
    TKinokoViewKoapColorTrimming(TKinokoView* View, const std::string& ColorName, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapColorTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapTextAdjustmentTrimming: public TKinokoViewTextAdjustmentTrimming {
  public:
    TKinokoViewKoapTextAdjustmentTrimming(TKinokoView* View, const std::string& TextAdjustmentString, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapTextAdjustmentTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


class TKinokoViewKoapFontTrimming: public TKinokoViewFontTrimming {
  public:
    TKinokoViewKoapFontTrimming(TKinokoView* View, const std::string& FontName, int FontSize, std::ostream* OutputStream);
    virtual ~TKinokoViewKoapFontTrimming();
    virtual void Draw(void);
  protected:
    std::ostream* _OutputStream;
    std::string _Name;
};


#endif
