/* KinokoWaveView.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 2 April 2001. */


#ifndef __KinokoWaveView_hh__
#define __KinokoWaveView_hh__


#include <iostream>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoView.hh"


class TKinokoWaveView: public TKinokoView {
  public:
    TKinokoWaveView(kame::TKameNtuple* KameNtuple, double XMin, double XMax, double YMin, double YMax);
    virtual ~TKinokoWaveView();
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
  protected:
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    kame::TKameNtuple* _Ntuple;
    double _XMin, _XMax, _YMin, _YMax;
    std::string _XTitle, _YTitle;
};



class TKinokoKoapWaveView: public TKinokoWaveView {
  public:
    TKinokoKoapWaveView(kame::TKameNtuple* Ntuple, double XMin, double XMax, double YMin, double YMax, std::ostream* OutputStream);
    virtual ~TKinokoKoapWaveView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
