/* KinokoCompositeDataProcessor-kcom.cc */
/* Created by Enomoto Sanshiro on 23 April 2001. */
/* Last updated by Enomoto Sanshiro on 14 December 2002. */


//== NOTE ==////////////////////////////////////////////////////////////////
//
//  This is an example program for user defined data-processing components.
//  The include file "MyDataProcessor.hh" and the class "MyDataProcessor"
//  are user defined. Make sure that the include file and the class are
//  replaced before compiling this program.
//
////////////////////////////////////////////////////////////////////////////


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoDataProcessorCom.hh"

#include "MyDataProcessor.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    
    TKinokoDataProcessor* DataProcessor = new TKinkoCompositeDataProcessor();

    int DataSourceId;
    DataProcessor->AddDataProcessor(
	"MyDataProcessor1", DataSourceId = 1, new TMyDataProcessor1()
    );
    DataProcessor->AddDataProcessor(
	"MyDataProcessor2", DataSourceId = 2, new TMyDataProcessor2()
    );

    TKcomComponent* Component = new TKinokoDataProcessorCom(DataProcessor);
    TKcomProcess* ComProcess = new TKcomProcess(Component);    

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    // delete registered analyzers //
    DataProcessor->Destroy();

    delete ComProcess;
    delete Component;
    delete DataProcessor;

    return 0;
}
