/* KinokoDataFlowMeter-kcom.cc */
/* Created by Enomoto Sanshiro on 22 May 2001. */
/* Last updated by Enomoto Sanshiro on 22 May 2001. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoDataProcessorCom.hh"

#include "KinokoDataFlowMeter.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    
    TKinokoDataProcessor* MyDataProcessor = new TKinokoDataFlowMeter();
    TKcomComponent* Component = new TKinokoDataProcessorCom(MyDataProcessor);
    TKcomProcess* ComProcess = new TKcomProcess(Component);    

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;
    delete MyDataProcessor;

    return 0;
}
