/* KinokoReproducer-kcom.cc */
/* Created by Enomoto Sanshiro on 24 December 2001. */
/* Last updated by Enomoto Sanshiro on 24 December 2001. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoReproducerCom.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    TMushArgumentList ArgumentList(argc, argv);
    
    TKcomComponent* Component = new TKinokoReproducerCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);
    
    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
