/* kdfdump.cc */
/* Created by Enomoto Sanshiro on 25 October 1999. */
/* Last updated by Enomoto Sanshiro on 23 February 2002. */


#include <cstdlib>
#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoKdfReader.hh"
#include "KinokoDataDumper.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << ArgumentList.ProgramName();
	cerr << " [Options] DataFileName [ DataSourceName [ SectionName ... ] ]" << endl;
	cerr << "Parameters:" << endl;
	cerr << "  DataFileName      input KDF data file name" << endl;
	cerr << "  DataSourceName    datasource name to display; omit it for all, use '-' for an arbitrary one" << endl;
	cerr << "  SectionName       section name to display; omit it for all" << endl;
	cerr << "Options:" << endl;
	cerr << "  -b, --binary      dumps raw binary data" << endl;
	cerr << "  -p, --packet      dumps raw data packet" << endl;
	cerr << "  --format=N        outputs in old version format" << endl;
        return EXIT_FAILURE;
    }

    string DataFileName = ArgumentList[0];
    string DataSourceName = "";
    if (ArgumentList.NumberOfParameters() > 1) {
	DataSourceName = ArgumentList[1];
    }

    bool IsBinaryDump = ArgumentList.IsOptionSpecified("--binary", 'b');
    bool IsPacketDump = ArgumentList.IsOptionSpecified("--packet", 'p');

    int FormatVersion;
    try {
	FormatVersion = ArgumentList.IntOptionValueOf("--format", 0);
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
	return EXIT_FAILURE;
    }

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataDumper* Analyzer;

    if (IsPacketDump) {
	Analyzer = new TKinokoPacketDumper(cout);
    }
    else if (IsBinaryDump) {
	Analyzer = new TKinokoDataDumper(cout);
    }
    else {
	Analyzer = new TKinokoTextDataDumper(cout, FormatVersion);
    }
    
    for (int Index = 2; Index < ArgumentList.NumberOfParameters(); Index++) {
	Analyzer->AddTargetSection(ArgumentList[Index]);
    }

    try {
	if (DataSourceName.empty()) {
	    KdfReader->RegisterCommonAnalyzer(Analyzer);
	}
	else {
	    if (DataSourceName[0] == '-') {
		DataSourceName = "";
	    }
	    KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);
	}

	if ((! IsPacketDump) && (! IsBinaryDump)) {
	    KdfReader->StorageHeader()->WriteTo(cout, "# ");
	    cout << endl;
	}

	KdfReader->Start();
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
