/* kdflist.cc */
/* Created by Enomoto Sanshiro on 26 August. */
/* Last updated by Enomoto Sanshiro on 26 August 2005. */


#include <iostream>
#include <iomanip>
#include <string>
#include <cstdlib>
#include "MushArgumentList.hh"
#include "MushFileSystem.hh"
#include "KinokoKdfStorage.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << ArgumentList.ProgramName();
	cerr << " DataFileName ..." << endl;
        return EXIT_FAILURE;
    }

    for (int i = 0; i < ArgumentList.NumberOfParameters(); i++) {
	try {
	    string DataFileName = ArgumentList[i];
	    TMushFileAttribute FileAttribute(DataFileName);

	    TKinokoKdfStorage Storage(DataFileName);
	    TKinokoStorageHeader StorageHeader;
	    Storage.ReadHeader(StorageHeader);
	    
	    cout.setf(ios::left);
	    cout << setw(15) << DataFileName << "   ";
	    cout << StorageHeader.ValueOf("UserName") << "   ";
	    cout.setf(ios::right);
	    cout << setw(6) << FileAttribute.Size() << "   ";
	    cout.setf(ios::left);
	    cout << StorageHeader.ValueOf("DateTime") << "   ";
	    cout << StorageHeader.ValueOf("Comment") << "   ";
	    cout << endl;
	}
	catch (TKinokoException& e) {
	    cout << endl;
	}
    }
	
    return 0;
}
