/* kdfprofile.cc */
/* Created by Enomoto Sanshiro on 25 October 1999. */
/* Last updated by Enomoto Sanshiro on 23 February 2002. */


#include <cstdlib>
#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoKdfReader.hh"
#include "KinokoDataProfiler.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << ArgumentList.ProgramName();
	cerr << " DataFileName [DataSourceName]" << endl;
        return EXIT_FAILURE;
    }

    string DataFileName = ArgumentList[0];
    string DataSourceName = "";
    if (ArgumentList.NumberOfParameters() > 1) {
	DataSourceName = ArgumentList[1];
    }

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataProfiler* Analyzer = new TKinokoDataProfiler();
    
    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);

	KdfReader->StorageHeader()->WriteTo(cout, "# ");
	cout << endl;

	KdfReader->ProcessUntilRunBegin();

	KdfReader->DataDescriptor()->WriteTo(cout);
	cout << endl;

	KdfReader->Start();

	Analyzer->WriteSummaryTo(cout);
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
