/* kinoko-module-definition.cc */
/* Created by Enomoto Sanshiro on 30 July 2008. */
/* Last updated by Enomoto Sanshiro on 30 July 2008. */


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "RoomDeviceFactory.hh"

using namespace std;

int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    string ModuleName = ArgumentList[0];

    TRoomModule* Module = 0;

    try {
	Module = TRoomDeviceFactory::GetInstance()->CreateVmeModule(ModuleName);
    }
    catch (THardwareException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    if (Module == 0) {
	cerr << "ERROR: unable to find module: " << ModuleName << endl;
	return -1;
    }

    Module->WriteInterfaceDefinition(cout);
    delete Module;

    return 0;
}
