/* knt2root.cc */
/* Created by Enomoto Sanshiro on 10 December 2009. */
/* Last updated by Enomoto Sanshiro on 10 December 2009. */


#include <iostream>
#include <string>
#include "MushFileSystem.hh"
#include "KiscNtuple.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0];
	cerr << " InputFileName [ OutputFileName [ ObjectName ]]" << endl;
	cerr << "   to read from stdin, use - for InputFileName" << endl;
        return -1;
    }

    string InputFileName = argv[1];
    string OutputFileName;
    if (argc > 2) {
	OutputFileName = argv[2];
    }
    else {
	if (InputFileName == "-") {
	    OutputFileName = "noname";
	}
	else {
	    OutputFileName = TMushFileAttribute(InputFileName).FileRootName();
	}
	OutputFileName += ".root";
    }
    string ObjectName;
    if (argc > 3) {
	ObjectName = argv[3];
    }

    if (InputFileName == "-") {
	InputFileName.erase();
    }

    TKiscNtuple Ntuple;
    try {
	Ntuple.Load("", InputFileName); // single object repository //

	if (ObjectName.empty()) {
	    ObjectName = (string) Ntuple.Property("Name");
	}
	if (ObjectName.empty()) {
	    ObjectName = (string) Ntuple.Property("DataSource");
	}
	if (ObjectName.empty()) {
	    ObjectName = TMushFileAttribute(OutputFileName).FileRootName();
	}
	Ntuple.Save(OutputFileName, ObjectName);
    }
    catch (TScriptException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
